package net.minecraft.mypeople;

import java.util.Iterator;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class ContainerCentrifuge extends Container{

	TileEntityCentrifuge tE;
	
	private int lastCurrentItemBurnTime;
	private int lastFurnaceBurnTime;
	private int lastTimeSpun;
	public ContainerCentrifuge(InventoryPlayer inventoryplayer, TileEntityCentrifuge tE){
		this.tE = tE;
		addSlotToContainer(new SlotCentrifuge(tE, 0, 80, 7));
		addSlotToContainer(new SlotCentrifuge(tE, 1, 102, 29));
		addSlotToContainer(new SlotCentrifuge(tE, 2, 80, 51));
		addSlotToContainer(new SlotCentrifuge(tE, 3, 58, 29));
		addSlotToContainer(new Slot(tE, 4, 80, 29));
        for (int j = 0; j < 9; j++)
        {
        	addSlotToContainer(new Slot(inventoryplayer, j, 8 + j * 18, 142));
        }
        for (int i = 0; i < 3; i++)
        {
            for (int k = 0; k < 9; k++)
            {
            	addSlotToContainer(new Slot(inventoryplayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }


	}
	
	public ItemStack transferStackInSlot(EntityPlayer par1EntityPlayer, int i)
    {
        ItemStack itemstack = null;
        Slot slot = (Slot)inventorySlots.get(i);
        if (slot != null && slot.getHasStack())
        {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if(i >= 0 && i < 4){
            	if (!mergeItemStack(itemstack1, 5, 41, true))
                {
                    return null;
                }
            }else if(i == 4){
            	if (!mergeItemStack(itemstack1, 5, 41, true))
                {
                    return null;
                }
            }else if(i >= 5 && i < 42){
            	if(itemstack1.itemID == MyPeople.testTubeBlood.itemID){
            		if (!tE.isSpinning() && !mergeItemStack(itemstack1, 0, 4, true))
                    {
                        return null;
                    }
            	}else if(TileEntityFurnace.getItemBurnTime(itemstack1)>0){
            		if (!mergeItemStack(itemstack1, 4, 5, true))
                    {
                        return null;
                    }
            	}
            }
            if (itemstack1.stackSize == 0)
            {
                slot.putStack(null);
            }
            else
            {
                slot.onSlotChanged();
            }
            if (itemstack1.stackSize != itemstack.stackSize)
            {
                slot.onPickupFromSlot(par1EntityPlayer, itemstack1);
            }
            else
            {
                return null;
            }
        }
        return itemstack;
    }
	
	public boolean canInteractWith(EntityPlayer entityplayer) {
		return true;
	}
	
	

/*	@Override
	public void onCraftMatrixChanged(IInventory par1iInventory) {
		super.onCraftMatrixChanged(par1iInventory);
	}
*/
	@Override
	public void addCraftingToCrafters(ICrafting par1iCrafting) {
		super.addCraftingToCrafters(par1iCrafting);
		par1iCrafting.sendProgressBarUpdate(this, 0, tE.currentItemBurnTime);
		par1iCrafting.sendProgressBarUpdate(this, 1, tE.furnaceBurnTime);
		par1iCrafting.sendProgressBarUpdate(this, 2, tE.timeSpun);
	}

	
	
	@Override
	public void detectAndSendChanges() {
		super.detectAndSendChanges();
		Iterator var1 = crafters.iterator();
		while(var1.hasNext()){
			ICrafting crafting = (ICrafting)var1.next();
			if(tE.currentItemBurnTime != lastCurrentItemBurnTime){
				crafting.sendProgressBarUpdate(this, 0, tE.currentItemBurnTime);
			}
			if(tE.furnaceBurnTime != lastFurnaceBurnTime){
				crafting.sendProgressBarUpdate(this, 1, tE.furnaceBurnTime);
			}
			if(tE.timeSpun != lastTimeSpun){
				crafting.sendProgressBarUpdate(this, 2, tE.timeSpun);
			}
		}
		
		lastCurrentItemBurnTime = tE.currentItemBurnTime;
		lastFurnaceBurnTime = tE.furnaceBurnTime;
		lastTimeSpun = tE.timeSpun;
	}

	@Override
	public void updateProgressBar(int par1, int par2) {
		if(par1 == 0){
			tE.currentItemBurnTime = par2;
		}
		if(par1 == 1){
			tE.furnaceBurnTime = par2;
		}
		if(par1 == 2){
			tE.timeSpun = par2;
			if(par2 > 0){
				tE.spinPressed = true;
			}else{
				tE.spinPressed = false;
			}
		}
	}
	
	

}
