package net.minecraft.mypeople;

import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class BreakBlockEntry {
	
	int id, meta;
	
	
	public BreakBlockEntry(int id, int meta){
		this.id = id;
		this.meta = meta;
	}
	
	public Block getBlock(){
		if(id > 0 && id < Block.blocksList.length){
			return Block.blocksList[id];
		}
		return null;
	}
	
	public String getBlockName(){
		if(id > -1 && id < Block.blocksList.length){
			ItemStack stack = new ItemStack(id, 1, meta);
			return stack.getDisplayName();
		}
		return "\2474An unknown block?";
	}
	
	public boolean compare(BreakBlockEntry entry){
		if(entry == null){
			return false;
		}
		if(entry.id == id && entry.meta == meta){
			return true;
		}
		return false;
	}
	
	public BreakBlockEntry clone(){
		return new BreakBlockEntry(id, meta);
	}
}
