package net.minecraft.mypeople;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class BlockSplicer extends BlockContainer{

	Icon side;
	
	public BlockSplicer(int par1) {
		super(par1, Material.rock);
	}

	@Override
	public boolean onBlockActivated(World par1World, int par2, int par3, int par4, EntityPlayer player, int par6, float par7, float par8, float par9) {
		player.openGui(MyPeople.instance, MyPersonGuiHandler.SPLICER, par1World, par2, par3, par4);
		return true;
	}

    @Override
	public void breakBlock(World par1World, int par2, int par3, int par4, int par5, int par6) {
    	TileEntity tE = par1World.getBlockTileEntity(par2, par3, par4);
    	if(tE != null && tE instanceof TileEntitySplicer){
    		((TileEntitySplicer)tE).dropAllItems(par1World, par2, par3, par4);
    	}
		super.breakBlock(par1World, par2, par3, par4, par5, par6);
	}

	@Override
	public TileEntity createNewTileEntity(World world) {
		return new TileEntitySplicer();
	}

	


	@Override
	public Icon getIcon(int par1, int par2) {
		if(par1 == 1){
			return blockIcon;
		}else{
			return side;
		}
	}

	@Override
	public void registerIcons(IconRegister r) {
		blockIcon = r.registerIcon("MyPeople:splicerTop");
		side = r.registerIcon("MyPeople:splicerSide");
	}
	
	
	
	

}
