package net.minecraft.mypeople.item;

import java.util.HashMap;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.mypeople.GuiCloneTracker;
import net.minecraft.mypeople.MyPeople;
import net.minecraft.mypeople.MyPeoplePacketType;
import net.minecraft.mypeople.MyPersonGuiHandler;
import net.minecraft.mypeople.entity.EntityMyPerson;
import net.minecraft.world.World;

public class ItemPersonFinder extends Item{
	
	public ItemPersonFinder(int i){
		super(i);
		this.setCreativeTab(CreativeTabs.tabTools);
	}

	HashMap<Integer, Integer> updates = new HashMap<Integer, Integer>();
	
	@Override
	public void onUpdate(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
		if(par2World.isRemote){
			if(!updates.containsKey(par4)){
				updates.put(par4, 0);
			}else{
				updates.put(par4, updates.get(par4)+1);
			}
			if(updates.get(par4) > 10){
				update();
				updates.put(par4, 0);
			}
		}
	}
	
	public void update(){
		EntityMyPerson clone = MyPeople.instance.cloneToFind;
		if(clone != null){
			MyPeople.instance.packetHandler.sendPacketToServer(MyPeoplePacketType.serverUpdateTracker.id, new Object[]{clone.entityId});
		}

	}

	

	@Override
	public void registerIcons(IconRegister par1IconRegister) {
		itemIcon = par1IconRegister.registerIcon("MyPeople:cloneTracker");
		if(par1IconRegister instanceof TextureMap){
			TextureMap tm = (TextureMap)par1IconRegister;
			tm.setTextureEntry("MyPeople:cloneTracker", new TexturePersonFinderStiched());
		}
	}

	@Override
	public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
		entityplayer.openGui(MyPeople.instance, MyPersonGuiHandler.PERSONFINDER, world, 0, 0, 0);
		return itemstack;
	}

	@Override
	public boolean onItemUse(ItemStack par1ItemStack,
			EntityPlayer par2EntityPlayer, World par3World, int par4, int par5,
			int par6, int par7, float par8, float par9, float par10) {
		if(par3World.isRemote){
			Minecraft.getMinecraft().displayGuiScreen(new GuiCloneTracker());
		}
		return true;
	}
	
	
	
	

}
