package net.minecraft.mypeople.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.mypeople.SpawnData;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntitySpawnEggThrow extends EntityThrowable{

	SpawnData spawnData = null;
	
	ItemStack stack = null;
	
	public EntitySpawnEggThrow(World par1World, EntityLiving living) {
		super(par1World, living);
	}
	
	public EntitySpawnEggThrow(World par1World, EntityLiving living, ItemStack stack){
		this(par1World, living);
		this.spawnData = SpawnData.get(stack);
		this.stack = stack;
	}

	
	@Override
	public void writeEntityToNBT(NBTTagCompound nbt) {
		super.writeEntityToNBT(nbt);
		NBTTagCompound data = new NBTTagCompound();
		if(spawnData != null){
			spawnData.saveTo(data);
		}
		nbt.setTag("Data", data);
		if(stack != null){
			NBTTagCompound itemStack = new NBTTagCompound();
			stack.writeToNBT(itemStack);
			nbt.setTag("itemStack", itemStack);
		}
	}

	@Override
	public void readEntityFromNBT(NBTTagCompound nbt) {
		super.readEntityFromNBT(nbt);
		NBTTagCompound data = (NBTTagCompound)nbt.getCompoundTag("Data");
		if(data != null){
			spawnData = new SpawnData(nbt);
		}
		if(nbt.hasKey("itemStack")){
			NBTTagCompound itemStack = (NBTTagCompound)nbt.getTag("itemStack");
			stack = ItemStack.loadItemStackFromNBT(itemStack);
		}
	}
	
	public ItemStack getItemStack(){
		return stack;
	}

	@Override
	protected void onImpact(MovingObjectPosition mop) {
		if(mop.typeOfHit == EnumMovingObjectType.ENTITY){
			Entity hit = mop.entityHit;
			double x, y, z;
			x = mop.hitVec.xCoord;
			y = mop.hitVec.yCoord;
			z = mop.hitVec.zCoord;
			if(hit != null){
				y = hit.posY+.2d;
			}
			if(spawnData != null){
				spawnData.spawnEntity(worldObj, x, y, z);
			}
		}else{
			double x = mop.hitVec.xCoord;
			double y = mop.hitVec.yCoord;
			double z = mop.hitVec.zCoord;
	/*		if(worldObj.getBlockId((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z)) != 0){
				y+= 1;
			}*/
			int side = mop.sideHit;
			if(spawnData != null){
				spawnData.spawnEntity(worldObj, x, y, z/*, mop.blockY, mop.blockZ*/, mop.sideHit);
			}else{
				System.out.println("Error: Spawn data is missing.");
			}
		}
		this.setDead();
	}

}
