package net.minecraft.mypeople;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.IntHashMap;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class MyPeopleFieldGrabbers {

	public static Set trackedEntities(EntityTracker object){
		try {return (Set) trackedEntities.get(object);} catch (Exception e) {e.printStackTrace();}
		return null;
	}
	
	public static IntHashMap entityIdMap(WorldServer object){
		try {return (IntHashMap) entityIdMap.get(object);} catch (Exception e) {e.printStackTrace();}
		return null;
	}
	
	public static int blockType(ItemSeeds object){
		try {return (Integer) blockType.get(object);} catch (Exception e) {e.printStackTrace();}
		return Block.crops.blockID;
	}
	
	public static int soilBlockID(ItemSeeds object){
		try {return (Integer) soilBlockID.get(object);} catch (Exception e) {e.printStackTrace();}
		return Block.tilledField.blockID;
	}

	public static int timeSinceIgnited(EntityCreeper object) {
		try {return (Integer) soilBlockID.get(object);} catch (Exception e) {e.printStackTrace();}
		return 0;
	}
	
	public static Map stringToClassMapping() {
		try {return (Map) stringToClassMapping.get(null);} catch (Exception e) {e.printStackTrace();}
		return null;
	}
	
	public static EnumToolMaterial toolMaterial(ItemSword object){
		try {return (EnumToolMaterial) toolMaterial.get(object);} catch (Exception e) {e.printStackTrace();}
		return null;
	}
	
	public static Map classToIDMapping(){
		try {return (Map) classToIDMapping.get(null);} catch (Exception e) {e.printStackTrace();}
		return null;
	}
	
	public static RenderBlocks globalRenderBlocks(RenderGlobal object){
		try {return (RenderBlocks) globalRenderBlocks.get(null);} catch (Exception e) {e.printStackTrace();}
		return null;
	}
	
	public static Block[] blocksEffectiveAgainst(ItemTool tool){
		try {return (Block[]) blocksEffectiveAgainst.get(tool);} catch (Exception e) {e.printStackTrace();}
		return null;
	}
	
	public static List unloadedEntityList(WorldServer world) {
		try {return (List) unloadedEntityList.get(world);} catch (Exception e) {e.printStackTrace();}
		return null;
	}
	
	public static float blockHardness(Block block) {
		try {return (Float) blockHardness.get(block);} catch (Exception e) {e.printStackTrace();}
		return -1f;
	}
	
	public static PositionTextureVertex[] vertexPositions(ModelBox object) {
		try {return (PositionTextureVertex[]) vertexPositions.get(object);} catch (Exception e) {e.printStackTrace();}
		return null;
	}
	//--------------------------------------------------------------------------------------//
	static{
		grabFields();
	}
	//PositionTextureVertex
	protected static Field trackedEntities, entityIdMap, blockType, soilBlockID, timeSinceIgnited,
	stringToClassMapping, toolMaterial, classToIDMapping, globalRenderBlocks, blocksEffectiveAgainst,
	unloadedEntityList, blockHardness, vertexPositions;
	
	protected static void grabFields(){
		trackedEntities = grabByType(EntityTracker.class, Set.class, 0);
//		System.out.println(trackedEntities);
		entityIdMap = grabByType(WorldServer.class, IntHashMap.class, 0);
		blockType = grabByNumber(ItemSeeds.class, 0);
		soilBlockID = grabByNumber(ItemSeeds.class, 1);
		timeSinceIgnited = grabByNumber(EntityCreeper.class, 1);
		stringToClassMapping = grabByNumber(EntityList.class, 0);
		classToIDMapping = grabByNumber(EntityList.class, 3);
		toolMaterial = grabByType(ItemSword.class, EnumToolMaterial.class, 0);
		globalRenderBlocks = grabByType(RenderGlobal.class, RenderBlocks.class, 0);
		blocksEffectiveAgainst = grabByNumber(ItemTool.class, 0);
		unloadedEntityList = grabByType(World.class, List.class, 1);
		blockHardness = grabByType(Block.class, Float.class, 0);
		if(blockHardness == null){
			blockHardness = grabByType(Block.class, float.class, 0);
		}
		vertexPositions = grabByType(ModelBox.class, PositionTextureVertex[].class, 0);
	}
	
	protected static Field grabByNumber(Class theClass, int fieldIndex){
		if(theClass != null && fieldIndex > -1){
			Field[] fields = theClass.getDeclaredFields();
			if(fieldIndex < fields.length){
				fields[fieldIndex].setAccessible(true);
				return fields[fieldIndex];
			}
		}
		return null;
	}
	
	protected static Field grabByName(Class theClass, String name){
		if(theClass != null && name != null && !name.isEmpty()){
			Field[] fields = theClass.getDeclaredFields();
			for(int a = 0; a < fields.length; a++){
				if(fields[a] != null && fields[a].getName().equals(name)){
					fields[a].setAccessible(true);
					return fields[a];
				}
			}
		}
		return null;
	}
	
	protected static Field grabByType(Class theClass, Class type, int index){
		if(theClass != null && type != null){
			Field[] fields = theClass.getDeclaredFields();
			int current = 0;
			for(int a = 0; a < fields.length; a++){
				if(fields[a] != null && fields[a].getType() == type){
					if(current == index){
						fields[a].setAccessible(true);
						return fields[a];
					}else{
						current = current + 1;
					}
				}
			}
		}
		return null;
	}


	
	/*
	public static TYPE NAME(OBJECT object){
		try {return (TYPE) NAME.get(object);} catch (Exception e) {e.printStackTrace();}
		return null;
	}
	*/
	
}
