package net.minecraft.mypeople;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

import org.lwjgl.opengl.GL11;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;

public class HumanEggRenderHandler implements ISimpleBlockRenderingHandler{

	int id;
	
	public HumanEggRenderHandler(int id){
		this.id = id;
	}
	
	@Override
	public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
		renderInventory(renderer, block);
	}

	@Override
	public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
		renderBlockHumanEgg(block, x, y, z, renderer);
		return false;
	}

	@Override
	public boolean shouldRender3DInInventory() {
		return true;
	}

	@Override
	public int getRenderId() {
		return id;
	}
	
	public void renderInventory(RenderBlocks rb, Block par1Block){
		Tessellator tessellator = Tessellator.instance;
        int k = 0;
        GL11.glTranslatef(-0.5F, -0.5F, -0.5F);
        tessellator.startDrawingQuads();

        for (int l = 0; l < 8; ++l)
        {
            byte b0 = 0;
            byte b1 = 1;

            if (l == 0)
            {
                b0 = 2;
            }

            if (l == 1)
            {
                b0 = 3;
            }

            if (l == 2)
            {
                b0 = 4;
            }

            if (l == 3)
            {
                b0 = 5;
                b1 = 2;
            }

            if (l == 4)
            {
                b0 = 6;
                b1 = 3;
            }

            if (l == 5)
            {
                b0 = 7;
                b1 = 5;
            }

            if (l == 6)
            {
                b0 = 6;
                b1 = 2;
            }

            if (l == 7)
            {
                b0 = 3;
            }

            float f4 = (float)b0 / 16.0F;
            float f5 = 1.0F - (float)k / 16.0F;
            float f6 = 1.0F - (float)(k + b1) / 16.0F;
            k += b1;
            rb.setRenderBounds((double)(0.5F - f4), (double)f6, (double)(0.5F - f4), (double)(0.5F + f4), (double)f5, (double)(0.5F + f4));
            tessellator.setNormal(0.0F, -1.0F, 0.0F);
            rb.renderFaceYNeg(par1Block, 0.0D, 0.0D, 0.0D, rb.getBlockIconFromSide(par1Block, 0));
            tessellator.setNormal(0.0F, 1.0F, 0.0F);
            rb.renderFaceYPos(par1Block, 0.0D, 0.0D, 0.0D, rb.getBlockIconFromSide(par1Block, 1));
            tessellator.setNormal(0.0F, 0.0F, -1.0F);
            rb.renderFaceZNeg(par1Block, 0.0D, 0.0D, 0.0D, rb.getBlockIconFromSide(par1Block, 2));
            tessellator.setNormal(0.0F, 0.0F, 1.0F);
            rb.renderFaceZPos(par1Block, 0.0D, 0.0D, 0.0D, rb.getBlockIconFromSide(par1Block, 3));
            tessellator.setNormal(-1.0F, 0.0F, 0.0F);
            rb.renderFaceXNeg(par1Block, 0.0D, 0.0D, 0.0D, rb.getBlockIconFromSide(par1Block, 4));
            tessellator.setNormal(1.0F, 0.0F, 0.0F);
            rb.renderFaceXPos(par1Block, 0.0D, 0.0D, 0.0D, rb.getBlockIconFromSide(par1Block, 5));
            /*            tessellator.setNormal(0.0F, -1.0F, 0.0F);
            rb.renderFa.renderBottomFace(par1Block, 0.0D, 0.0D, 0.0D, rb.getBlockIconFromSide(par1Block, 0));
            tessellator.setNormal(0.0F, 1.0F, 0.0F);
            rb.renderTopFace(par1Block, 0.0D, 0.0D, 0.0D, rb.getBlockIconFromSide(par1Block, 1));
            tessellator.setNormal(0.0F, 0.0F, -1.0F);
            rb.renderEastFace(par1Block, 0.0D, 0.0D, 0.0D, rb.getBlockIconFromSide(par1Block, 2));
            tessellator.setNormal(0.0F, 0.0F, 1.0F);
            rb.renderWestFace(par1Block, 0.0D, 0.0D, 0.0D, rb.getBlockIconFromSide(par1Block, 3));
            tessellator.setNormal(-1.0F, 0.0F, 0.0F);
            rb.renderNorthFace(par1Block, 0.0D, 0.0D, 0.0D, rb.getBlockIconFromSide(par1Block, 4));
            tessellator.setNormal(1.0F, 0.0F, 0.0F);
            rb.renderSouthFace(par1Block, 0.0D, 0.0D, 0.0D, rb.getBlockIconFromSide(par1Block, 5));*/
        }

        tessellator.draw();
        GL11.glTranslatef(0.5F, 0.5F, 0.5F);
        rb.setRenderBounds(0.0D, 0.0D, 0.0D, 1.0D, 1.0D, 1.0D);
	}
	
    public boolean renderBlockHumanEgg(Block par1BlockDragonEgg, int par2, int par3, int par4, RenderBlocks rb)
    {
        boolean flag = false;
        int l = 0;

        for (int i1 = 0; i1 < 8; ++i1)
        {
            byte b0 = 0;
            byte b1 = 1;

            if (i1 == 0)
            {
                b0 = 2;
            }

            if (i1 == 1)
            {
                b0 = 3;
            }

            if (i1 == 2)
            {
                b0 = 4;
            }

            if (i1 == 3)
            {
                b0 = 5;
                b1 = 2;
            }

            if (i1 == 4)
            {
                b0 = 6;
                b1 = 3;
            }

            if (i1 == 5)
            {
                b0 = 7;
                b1 = 5;
            }

            if (i1 == 6)
            {
                b0 = 6;
                b1 = 2;
            }

            if (i1 == 7)
            {
                b0 = 3;
            }

            float f = (float)b0 / 16.0F;
            float f1 = 1.0F - (float)l / 16.0F;
            float f2 = 1.0F - (float)(l + b1) / 16.0F;
            l += b1;
            rb.setRenderBounds((double)(0.5F - f), (double)f2, (double)(0.5F - f), (double)(0.5F + f), (double)f1, (double)(0.5F + f));
            rb.renderStandardBlock(par1BlockDragonEgg, par2, par3, par4);
        }

        flag = true;
        rb.setRenderBounds(0.0D, 0.0D, 0.0D, 1.0D, 1.0D, 1.0D);
        return flag;
    }
	

}
