package net.minecraft.mypeople;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class ContainerDnaCloner extends Container{
	
	InventoryPlayer pi;
	
	TileEntityDnaCloner te;
	
	int lastBurnTime = 0, lastItemBurnTime = 0, lastCopyTime = 0;
	int lastBlood = 0, lastWater = 0, lastLava = 0;
	
	public ContainerDnaCloner(InventoryPlayer pi, TileEntityDnaCloner te){
		this.pi = pi;
		this.te = te;
		this.addSlotToContainer(new SlotFuel(te, 0, 86, 42));
		this.addSlotToContainer(new SlotUnincubatedCapsule(te, 1, 86, 17));
		this.addSlotToContainer(new SlotType(MyPeople.testTubeBlood.itemID, 1, te, 2, 110, 8));
		this.addSlotToContainer(new SlotType(Item.bucketWater.itemID, 1, te, 3, 132, 8));
		this.addSlotToContainer(new SlotType(Block.slowSand.blockID, 64, te, 4, 152, 8));
		for(int b = 0; b < 4; b++){
			for(int a = 0; a < 3; a++){
				this.addSlotToContainer(new SlotType(MyPeople.emptyCapsule.itemID, 1, te, b*3 + a + 5
						, 8 + b*18, 11 + a*18));
			}
		}
		
        for (int j = 0; j < 9; j++)
        {
        	addSlotToContainer(new Slot(pi, j, 8 + j * 18, 142));
        }
		
        for (int i = 0; i < 3; i++)
        {
            for (int k = 0; k < 9; k++)
            {
            	addSlotToContainer(new Slot(pi, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
	}
	
	

	@Override
	public ItemStack transferStackInSlot(EntityPlayer par1EntityPlayer, int i) {
        ItemStack itemstack = null;
        Slot slot = (Slot)inventorySlots.get(i);
        if (slot != null && slot.getHasStack())
        {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
          //0 Fuel, 1 Copied Item, 2,3,4, Blood, Water, Lava, 5-16, Items
            if(i >= 0 && i < 17){
            	if(!mergeItemStack(itemstack1, 17, 53, true)){
            		return null;
            	}
            }else{
            	if(itemstack1.itemID == MyPeople.customSpawnEgg.itemID && SpawnData.isUnincubated(itemstack1)){
            		if(!mergeItemStack(itemstack1, 1, 2, true)){
                		return null;
                	}
            	}/*else if(itemstack.itemID == MyPeople.emptyCapsule.itemID){
            		if(!mergeItemStackMe(itemstack1, 5, 17, true)){
                		return null;
                	}
            	}*/else if(itemstack.itemID == MyPeople.testTubeBlood.itemID){
            		if(te.blood < 29){
            			te.blood+=4;
            			itemstack1.itemID = MyPeople.testTubeEmpty.itemID;
            			slot.onSlotChanged();
            		}else{
                		if(!mergeItemStack(itemstack1, 2, 3, true)){
                    		return null;
                    	}
            		}
            	}else if(itemstack.itemID == Item.bucketWater.itemID){
            		if(te.water < 29){
            			te.water+=4;
            			itemstack1.itemID = Item.bucketEmpty.itemID;
            			slot.onSlotChanged();
            		}else{
                		if(!mergeItemStack(itemstack1, 3, 4, true)){
                    		return null;
                    	}
            		}
            	}else if(itemstack.itemID == Block.slowSand.blockID){
            		if(te.souls < 25){
            			while(te.souls < 25){
                			te.souls+=8;
                			itemstack1.stackSize--;
                			if(itemstack1.stackSize == 0){
                				itemstack1 = null;
                				break;
                			}
            			}
            			slot.onSlotChanged();
            		}else{
                		if(!mergeItemStack(itemstack1, 4, 5, true)){
                    		return null;
                    	}
            		}
            	}else if(TileEntityFurnace.isItemFuel(itemstack1)){
            		if(!mergeItemStack(itemstack1, 0, 1, true)){
                		return null;
                	}
            	}else{
            		if(i > 16 && i < 26){
            			if(!mergeItemStack(itemstack1, 25, 53, true)){
                    		return null;
                    	}
            		}else if(i > 25 && i < 53){
            			if(!mergeItemStack(itemstack1, 16, 26, true)){
                    		return null;
                    	}
            		}
            	}
            }
            if (itemstack1.stackSize == 0)
            {
                slot.putStack(null);
            }
            else
            {
                slot.onSlotChanged();
            }
            if (itemstack1.stackSize != itemstack.stackSize)
            {
                slot.onPickupFromSlot(par1EntityPlayer, itemstack1);
            }
            else
            {
                return null;
            }
        }
        return itemstack;
	}



	@Override
	public void detectAndSendChanges() {
		super.detectAndSendChanges();

        for (int i = 0; i < this.crafters.size(); ++i)
        {
            ICrafting icrafting = (ICrafting)this.crafters.get(i);

            if (this.lastCopyTime != this.te.timeCopied)
            {
                icrafting.sendProgressBarUpdate(this, 0, this.te.timeCopied);
            }

            if (this.lastBurnTime != this.te.furnaceBurnTime)
            {
                icrafting.sendProgressBarUpdate(this, 1, this.te.furnaceBurnTime);
            }

            if (this.lastItemBurnTime != this.te.currentItemBurnTime)
            {
                icrafting.sendProgressBarUpdate(this, 2, this.te.currentItemBurnTime);
            }
            
            if (this.lastBlood != this.te.blood)
            {
                icrafting.sendProgressBarUpdate(this, 3, this.te.blood);
            }
            
            if (this.lastWater != this.te.water)
            {
                icrafting.sendProgressBarUpdate(this, 4, this.te.water);
            }
            
            if (this.lastLava != this.te.souls)
            {
                icrafting.sendProgressBarUpdate(this, 5, this.te.souls);
            }
        }

        this.lastCopyTime = this.te.timeCopied;
        this.lastBurnTime = this.te.furnaceBurnTime;
        this.lastItemBurnTime = this.te.currentItemBurnTime;
        
        this.lastBlood = this.te.blood;
        this.lastWater = this.te.water;
        this.lastLava = this.te.souls;
	}

    @SideOnly(Side.CLIENT)
    public void updateProgressBar(int par1, int par2)
    {
        if (par1 == 0)
        {
            this.te.timeCopied = par2;
        }

        if (par1 == 1)
        {
            this.te.furnaceBurnTime = par2;
        }

        if (par1 == 2)
        {
            this.te.currentItemBurnTime = par2;
        }
        
        if (par1 == 3)
        {
            this.te.blood = par2;
        }
        
        if (par1 == 4)
        {
            this.te.water = par2;
        }
        
        if (par1 == 5)
        {
            this.te.souls = par2;
        }
    }





	@Override
	protected void retrySlotClick(int par1, int par2, boolean par3, EntityPlayer par4EntityPlayer) {
		
	}



	@Override
	public boolean canInteractWith(EntityPlayer entityplayer) {
		return true;
	}

}
