/*
 * Decompiled with CFR 0.152.
 */
package morph.common.morph;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ichun.common.core.util.ObfHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import morph.common.Morph;
import morph.common.morph.MorphHandler;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;

public class MorphState
implements Comparable {
    public final int NBT_PROTOCOL = 2;
    public String playerName;
    public String playerMorph;
    public boolean isFavourite;
    public boolean isRemote;
    public EntityLivingBase entInstance;
    public String identifier;

    public MorphState(World world, String name, String player, NBTTagCompound tag, boolean remote) {
        this.playerName = name;
        this.playerMorph = player;
        this.isFavourite = name.equalsIgnoreCase(player);
        this.isRemote = remote;
        if (!player.equalsIgnoreCase("")) {
            this.entInstance = this.isRemote ? this.createPlayer(world, player) : new FakePlayer((WorldServer)world, new GameProfile("MorphFakePlayer", player));
        } else if (tag != null) {
            this.entInstance = (EntityLivingBase)EntityList.func_75615_a((NBTTagCompound)tag, (World)world);
        }
        if (this.entInstance != null) {
            NBTTagCompound fakeTag = new NBTTagCompound();
            this.entInstance.func_70014_b(fakeTag);
            this.writeFakeTags(this.entInstance, fakeTag);
            this.identifier = this.playerMorph.equalsIgnoreCase("") ? this.entInstance.getClass().toString() + MorphState.parseTag(fakeTag) : "playerMorphState::player_" + this.playerMorph;
        }
    }

    public NBTTagCompound getTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("playerName", this.playerName);
        tag.func_74778_a("playerMorph", this.playerMorph);
        tag.func_74757_a("isFavourite", this.isFavourite);
        NBTTagCompound tag1 = new NBTTagCompound();
        if (this.entInstance != null) {
            try {
                this.entInstance.func_70039_c(tag1);
            }
            catch (Exception e) {
                Morph.console(this.entInstance.toString() + " threw an exception when trying to save!", true);
                e.printStackTrace();
            }
            this.writeFakeTags(this.entInstance, tag1);
        }
        tag.func_74782_a("entInstanceTag", (NBTBase)tag1);
        tag.func_74778_a("identifier", this.identifier);
        return tag;
    }

    public void readTag(World world, NBTTagCompound tag) {
        NBTTagCompound fakeTag;
        this.playerName = tag.func_74779_i("playerName");
        this.playerMorph = tag.func_74779_i("playerMorph");
        this.isFavourite = tag.func_74767_n("isFavourite") || this.playerName.equals(this.playerMorph);
        NBTTagCompound tag1 = tag.func_74775_l("entInstanceTag");
        boolean invalid = false;
        if (this.playerName.equalsIgnoreCase("") || this.playerMorph.equalsIgnoreCase("") && tag1.func_74779_i("id").equalsIgnoreCase("")) {
            invalid = true;
        }
        if (!invalid) {
            if (!this.playerMorph.equalsIgnoreCase("")) {
                this.entInstance = this.isRemote ? this.createPlayer(world, this.playerMorph) : new FakePlayer((WorldServer)world, new GameProfile("MorphFakePlayer", this.playerMorph));
                this.identifier = "playerMorphState::player_" + this.playerMorph;
            } else {
                try {
                    this.entInstance = (EntityLivingBase)EntityList.func_75615_a((NBTTagCompound)tag1, (World)world);
                    this.identifier = tag.func_74779_i("identifier");
                    if (this.entInstance != null && (this.identifier.contains(":[") && this.identifier.endsWith("]") || tag1.func_74762_e("MorphNBTProtocolNumber") < 2) && !this.attemptRepairs(this.entInstance, tag1, tag1.func_74762_e("MorphNBTProtocolNumber"))) {
                        this.identifier = "";
                        invalid = true;
                    }
                }
                catch (Exception e) {
                    Morph.console("A mob (as a morph) is throwing an error when being read from NBT! You should report this to the mod author of the mob!", true);
                    e.printStackTrace();
                    invalid = true;
                }
            }
            if (this.entInstance == null) {
                invalid = true;
            } else if (this.identifier.equalsIgnoreCase("")) {
                fakeTag = new NBTTagCompound();
                this.entInstance.func_70014_b(fakeTag);
                this.writeFakeTags(this.entInstance, fakeTag);
                this.identifier = this.entInstance.getClass().toString() + MorphState.parseTag(fakeTag);
            }
        }
        if (invalid) {
            this.entInstance = (EntityLivingBase)EntityList.func_75620_a((String)"Pig", (World)world);
            fakeTag = new NBTTagCompound();
            this.entInstance.func_70014_b(fakeTag);
            this.writeFakeTags(this.entInstance, fakeTag);
            this.identifier = this.entInstance.getClass().toString() + MorphState.parseTag(fakeTag);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer createPlayer(World world, String player) {
        return new EntityOtherPlayerMP(world, new GameProfile("MorphClientDummyPlayer", player));
    }

    public void writeFakeTags(EntityLivingBase living, NBTTagCompound tag) {
        tag.func_74776_a("HealF", 32767.0f);
        tag.func_74777_a("Health", (short)Short.MAX_VALUE);
        tag.func_74777_a("HurtTime", (short)0);
        tag.func_74777_a("DeathTime", (short)0);
        tag.func_74777_a("AttackTime", (short)0);
        tag.func_74782_a("ActiveEffects", (NBTBase)new NBTTagList());
        tag.func_74782_a("Attributes", (NBTBase)new NBTTagList());
        tag.func_74777_a("Fire", (short)0);
        tag.func_74777_a("Anger", (short)0);
        tag.func_74768_a("Age", living.func_70631_g_() ? -24000 : 0);
        if (living instanceof EntityLiving) {
            EntityLiving living1 = (EntityLiving)living;
            NBTTagList tagList = new NBTTagList();
            for (int i = 0; i < living1.func_70035_c().length; ++i) {
                tagList.func_74742_a((NBTBase)new NBTTagCompound());
            }
            tag.func_74757_a("CanPickUpLoot", true);
            tag.func_74782_a("Equipment", (NBTBase)tagList);
            tag.func_74757_a("Leashed", false);
            tag.func_74757_a("PersistenceRequired", true);
        }
        ArrayList<String> stripList = MorphHandler.getNBTTagsToStrip(living);
        for (String s : stripList) {
            tag.func_82580_o(s);
        }
        tag.func_82580_o("bukkit");
        tag.func_82580_o("InLove");
        tag.func_74768_a("MorphNBTProtocolNumber", 2);
    }

    public static String parseTag(NBTTagCompound tag) {
        HashMap tagMap;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> tags = new ArrayList<String>();
        try {
            tagMap = (HashMap)ObfuscationReflectionHelper.getPrivateValue(NBTTagCompound.class, (Object)tag, (String[])ObfHelper.tagMap);
        }
        catch (Exception e) {
            ObfHelper.obfWarning();
            e.printStackTrace();
            tagMap = new HashMap();
        }
        Iterator i$ = tagMap.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry obj;
            Map.Entry e = obj = i$.next();
            tags.add(e.getKey().toString() + ":" + tagMap.get(e.getKey()));
        }
        Collections.sort(tags);
        sb.append("{");
        for (int i = 0; i < tags.size(); ++i) {
            sb.append((String)tags.get(i));
            if (i == tags.size() - 1) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean attemptRepairs(EntityLivingBase living, NBTTagCompound tag, int nbtProtocol) {
        while (nbtProtocol < 2) {
            if (nbtProtocol == 1) {
                tag.func_74768_a("MorphNBTProtocolNumber", 2);
                NBTTagCompound fakeTag = new NBTTagCompound();
                living.func_70014_b(fakeTag);
                this.writeFakeTags(living, fakeTag);
                this.identifier = living.getClass().toString() + MorphState.parseTag(fakeTag);
                tag.func_74778_a("identifier", this.identifier);
            }
            ++nbtProtocol;
        }
        tag.func_74768_a("MorphNBTProtocolNumber", nbtProtocol);
        return nbtProtocol >= 2;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof MorphState) {
            MorphState state = (MorphState)arg0;
            return this.identifier.compareTo(state.identifier);
        }
        return 0;
    }
}

