/*
 * Decompiled with CFR 0.152.
 */
package morph.common.morph;

import java.util.ArrayList;
import morph.api.Ability;
import morph.common.ability.AbilityHandler;
import morph.common.morph.MorphState;
import morph.common.packet.PacketMorphInfo;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class MorphInfo {
    public String playerName;
    public MorphState prevState;
    public MorphState nextState;
    private boolean morphing;
    public int morphProgress;
    public ArrayList<Ability> morphAbilities = new ArrayList();
    public boolean flying;
    public boolean sleeping;
    public double healthOffset;
    public double preMorphHealth;
    public boolean firstUpdate;

    public MorphInfo() {
        this.playerName = "";
    }

    public MorphInfo(String name, MorphState prev, MorphState next) {
        this.playerName = name;
        this.prevState = prev;
        this.nextState = next;
        this.morphing = false;
        this.morphProgress = 0;
        this.flying = false;
        this.sleeping = false;
        this.firstUpdate = true;
        this.healthOffset = 0.0;
        this.preMorphHealth = 20.0;
    }

    public void setMorphing(boolean flag) {
        this.morphing = flag;
    }

    public boolean getMorphing() {
        return this.morphing;
    }

    public PacketMorphInfo getMorphInfoAsPacket() {
        return new PacketMorphInfo(this.playerName, this.morphing, this.morphProgress, this.prevState != null, this.nextState != null, this.prevState != null ? this.prevState.getTag() : null, this.nextState != null ? this.nextState.getTag() : null, this.flying);
    }

    public void writeNBT(NBTTagCompound tag) {
        tag.func_74778_a("playerName", this.playerName);
        tag.func_74768_a("dimension", this.nextState.entInstance.field_71093_bK);
        tag.func_74782_a("nextState", (NBTBase)this.nextState.getTag());
        tag.func_74757_a("isFlying", this.flying);
        tag.func_74780_a("healthOffset", this.healthOffset);
        tag.func_74780_a("preMorphHealth", this.preMorphHealth);
    }

    public void readNBT(NBTTagCompound tag) {
        this.playerName = tag.func_74779_i("playerName");
        WorldServer dimension = DimensionManager.getWorld((int)tag.func_74762_e("dimension"));
        if (dimension == null) {
            dimension = DimensionManager.getWorld((int)0);
        }
        this.nextState = new MorphState((World)dimension, this.playerName, this.playerName, null, false);
        this.nextState.readTag((World)dimension, tag.func_74775_l("nextState"));
        this.morphing = true;
        this.morphProgress = 80;
        ArrayList<Ability> newAbilities = AbilityHandler.getEntityAbilities(this.nextState.entInstance.getClass());
        this.morphAbilities = new ArrayList();
        for (Ability ability : newAbilities) {
            try {
                this.morphAbilities.add(ability.clone());
            }
            catch (Exception e1) {}
        }
        this.flying = tag.func_74767_n("isFlying");
        this.healthOffset = tag.func_74769_h("healthOffset");
        this.preMorphHealth = tag.func_74769_h("preMorphHealth");
    }
}

