/*
 * Decompiled with CFR 0.152.
 */
package morph.client.model;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.ReflectionHelper;
import ichun.common.core.util.ObfHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import morph.client.model.ModelInfo;
import morph.common.Morph;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelCreeper;
import net.minecraft.client.model.ModelHorse;
import net.minecraft.client.model.ModelIronGolem;
import net.minecraft.client.model.ModelOcelot;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.ModelSpider;
import net.minecraft.client.model.ModelSquid;
import net.minecraft.client.model.ModelWolf;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;

public class ModelHelper {
    public static Random rand = new Random();
    public static HashMap<Class<? extends ModelBase>, ModelRenderer> armMappings = new HashMap();

    public static ArrayList<ModelRenderer> getModelCubesCopy(ModelInfo info, ModelBase base, EntityLivingBase ent) {
        if (ent != null) {
            info.forceRender((Entity)ent, 0.0, -500.0, 0.0, 0.0f, 1.0f);
            ArrayList<ModelRenderer> modelList = ModelHelper.getModelCubes(ModelHelper.getPossibleModel(info.getRenderer()));
            for (int i = 0; i < modelList.size(); ++i) {
                ModelRenderer cube = modelList.get(i);
                try {
                    if (!((Boolean)ObfuscationReflectionHelper.getPrivateValue(ModelRenderer.class, (Object)cube, (String[])ObfHelper.compiled)).booleanValue()) continue;
                    GLAllocation.func_74523_b((int)((Integer)ObfuscationReflectionHelper.getPrivateValue(ModelRenderer.class, (Object)cube, (String[])ObfHelper.displayList)));
                    ObfuscationReflectionHelper.setPrivateValue(ModelRenderer.class, (Object)cube, (Object)false, (String[])ObfHelper.compiled);
                    continue;
                }
                catch (Exception e) {
                    ObfHelper.obfWarning();
                    e.printStackTrace();
                }
            }
            info.forceRender((Entity)ent, 0.0, -500.0, 0.0, 0.0f, 1.0f);
            ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
            for (int i = 0; i < modelList.size(); ++i) {
                ModelRenderer cube = modelList.get(i);
                try {
                    if (!((Boolean)ObfuscationReflectionHelper.getPrivateValue(ModelRenderer.class, (Object)cube, (String[])ObfHelper.compiled)).booleanValue()) continue;
                    list.add(ModelHelper.buildCopy(cube, base, 0, true));
                    continue;
                }
                catch (Exception e) {
                    ObfHelper.obfWarning();
                    e.printStackTrace();
                }
            }
            return list;
        }
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        for (int i = 0; i < info.modelList.size(); ++i) {
            ModelRenderer cube = info.modelList.get(i);
            list.add(ModelHelper.buildCopy(cube, base, 0, true));
        }
        return list;
    }

    public static ModelRenderer getPotentialArm(ModelBase parent) {
        if (armMappings.containsKey(parent.getClass())) {
            return armMappings.get(parent.getClass());
        }
        if (parent != null) {
            Class<?> clz = parent.getClass();
            if (clz == ModelHorse.class) {
                ModelHorse dummy = new ModelHorse();
                ModelRenderer leg = new ModelRenderer((ModelBase)dummy, 60, 29);
                leg.func_78789_a(-1.1f, -1.0f, -2.1f, 3, 8, 4);
                leg.func_78793_a(-4.0f, 9.0f, -8.0f);
                ModelRenderer shin = new ModelRenderer((ModelBase)dummy, 60, 41);
                shin.func_78789_a(-1.1f, 0.0f, -1.6f, 3, 5, 3);
                shin.func_78793_a(0.0f, 7.0f, 0.0f);
                leg.func_78792_a(shin);
                ModelRenderer hoof = new ModelRenderer((ModelBase)dummy, 60, 51);
                hoof.func_78789_a(-1.6f, 5.1f, -2.1f, 4, 3, 4);
                hoof.func_78793_a(0.0f, 0.0f, 0.0f);
                shin.func_78792_a(hoof);
                return leg;
            }
            while (clz != ModelBase.class && ModelBase.class.isAssignableFrom(clz)) {
                try {
                    Field[] fields;
                    for (Field f : fields = clz.getDeclaredFields()) {
                        f.setAccessible(true);
                        if (f.getType() == ModelRenderer.class) {
                            ModelRenderer arm;
                            if ((clz != ModelBiped.class || !f.getName().equalsIgnoreCase("bipedRightArm") && !f.getName().equalsIgnoreCase("f") && !f.getName().equalsIgnoreCase("field_78112_f")) && (clz != ModelQuadruped.class || !f.getName().equalsIgnoreCase("leg3") && !f.getName().equalsIgnoreCase("e") && !f.getName().equalsIgnoreCase("field_78147_e")) && (clz != ModelCreeper.class || !f.getName().equalsIgnoreCase("leg3") && !f.getName().equalsIgnoreCase("f") && !f.getName().equalsIgnoreCase("field_78129_f")) && (clz != ModelIronGolem.class || !f.getName().equalsIgnoreCase("ironGolemRightArm") && !f.getName().equalsIgnoreCase("c") && !f.getName().equalsIgnoreCase("field_78177_c")) && (clz != ModelSpider.class || !f.getName().equalsIgnoreCase("spiderLeg7") && !f.getName().equalsIgnoreCase("j") && !f.getName().equalsIgnoreCase("field_78210_j")) && (clz != ModelWolf.class || !f.getName().equalsIgnoreCase("wolfLeg3") && !f.getName().equalsIgnoreCase("e") && !f.getName().equalsIgnoreCase("field_78182_e")) && (clz != ModelOcelot.class || !f.getName().equalsIgnoreCase("ocelotFrontRightLeg") && !f.getName().equalsIgnoreCase("d") && !f.getName().equalsIgnoreCase("field_78157_d")) && (clz == ModelBiped.class || clz == ModelQuadruped.class || clz == ModelCreeper.class || clz == ModelIronGolem.class || clz == ModelSpider.class || clz == ModelWolf.class || clz == ModelOcelot.class || !f.getName().contains("Right") && !f.getName().contains("right") || !f.getName().contains("arm") && !f.getName().contains("hand") && !f.getName().contains("Arm") && !f.getName().contains("Hand")) || (arm = (ModelRenderer)f.get(parent)) == null) continue;
                            return arm;
                        }
                        if (f.getType() != ModelRenderer[].class || clz != ModelSquid.class || !f.getName().equalsIgnoreCase("squidTentacles") && !f.getName().equalsIgnoreCase("b") && !f.getName().equalsIgnoreCase("field_78201_b")) continue;
                        return ((ModelRenderer[])f.get(parent))[0];
                    }
                    clz = clz.getSuperclass();
                }
                catch (Exception e) {
                    throw new ReflectionHelper.UnableToAccessFieldException(new String[0], e);
                }
            }
        }
        return null;
    }

    public static ArrayList<ModelRenderer> getModelCubes(ModelBase parent) {
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        ArrayList<ModelRenderer> list1 = new ArrayList<ModelRenderer>();
        if (parent != null) {
            for (Class<?> clz = parent.getClass(); clz != ModelBase.class && ModelBase.class.isAssignableFrom(clz); clz = clz.getSuperclass()) {
                try {
                    Field[] fields;
                    for (Field field : fields = clz.getDeclaredFields()) {
                        ModelRenderer rend;
                        field.setAccessible(true);
                        if (field.getType() == ModelRenderer.class) {
                            if ((clz != ModelBiped.class || field.getName().equalsIgnoreCase("bipedCloak") || field.getName().equalsIgnoreCase("k") || field.getName().equalsIgnoreCase("field_78122_k")) && clz == ModelBiped.class || (rend = (ModelRenderer)field.get(parent)) == null) continue;
                            list.add(rend);
                            continue;
                        }
                        if (field.getType() != ModelRenderer[].class || (rend = (ModelRenderer)field.get(parent)) == null) continue;
                        list1.add(rend);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new ReflectionHelper.UnableToAccessFieldException(new String[0], e);
                }
            }
        }
        Iterator i$ = list1.iterator();
        while (i$.hasNext()) {
            ModelRenderer[] cubes;
            for (ModelRenderer modelRenderer : cubes = (ModelRenderer[])i$.next()) {
                if (modelRenderer == null || list.contains(modelRenderer)) continue;
                list.add(modelRenderer);
            }
        }
        ArrayList<ModelRenderer> children = new ArrayList<ModelRenderer>();
        for (ModelRenderer modelRenderer : list) {
            for (ModelRenderer child : ModelHelper.getChildren(modelRenderer, true, 0)) {
                if (children.contains(child)) continue;
                children.add(child);
            }
        }
        for (ModelRenderer modelRenderer : children) {
            list.remove(modelRenderer);
        }
        return list;
    }

    public static ModelBase getPossibleModel(Render rend) {
        ArrayList models = new ArrayList();
        if (rend != null) {
            try {
                for (Class<?> clz = rend.getClass(); clz != Render.class; clz = clz.getSuperclass()) {
                    Field[] fields;
                    ArrayList<ModelBase> priorityLevel = new ArrayList<ModelBase>();
                    for (Field f : fields = clz.getDeclaredFields()) {
                        ModelBase[] modelBases;
                        f.setAccessible(true);
                        if (ModelBase.class.isAssignableFrom(f.getType())) {
                            ModelBase base = (ModelBase)f.get(rend);
                            if (base == null) continue;
                            priorityLevel.add(base);
                            continue;
                        }
                        if (!ModelBase[].class.isAssignableFrom(f.getType()) || (modelBases = (ModelBase[])f.get(rend)) == null) continue;
                        for (ModelBase base : modelBases) {
                            priorityLevel.add(base);
                        }
                    }
                    models.add(priorityLevel);
                    if (clz != RendererLivingEntity.class) continue;
                    ArrayList<ModelBase> topPriority = new ArrayList<ModelBase>();
                    for (Field f : fields) {
                        ModelBase base;
                        f.setAccessible(true);
                        if (!ModelBase.class.isAssignableFrom(f.getType()) || !f.getName().equalsIgnoreCase("mainModel") && !f.getName().equalsIgnoreCase("field_77045_g") || (base = (ModelBase)f.get(rend)) == null) continue;
                        topPriority.add(base);
                    }
                    models.add(topPriority);
                }
            }
            catch (Exception e) {
                throw new ReflectionHelper.UnableToAccessFieldException(new String[0], e);
            }
        }
        ModelBase base1 = null;
        int priorityLevel = -1;
        int size = -1;
        int currentPriority = 0;
        for (int i = 0; i < models.size(); ++i) {
            ArrayList modelList = (ArrayList)models.get(i);
            for (ModelBase base : modelList) {
                ArrayList<ModelRenderer> mrs = ModelHelper.getModelCubes(base);
                if (mrs.size() <= size && (mrs.size() != size || currentPriority <= priorityLevel)) continue;
                size = mrs.size();
                base1 = base;
                priorityLevel = currentPriority;
            }
            ++currentPriority;
        }
        return base1;
    }

    public static ArrayList<ModelRenderer> getChildren(ModelRenderer parent, boolean recursive, int depth) {
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        if (parent.field_78805_m != null && depth < 20) {
            for (int i = 0; i < parent.field_78805_m.size(); ++i) {
                ModelRenderer child = (ModelRenderer)parent.field_78805_m.get(i);
                if (recursive) {
                    ArrayList<ModelRenderer> children = ModelHelper.getChildren(child, recursive, depth + 1);
                    for (ModelRenderer child1 : children) {
                        if (list.contains(child1)) continue;
                        list.add(child1);
                    }
                }
                if (list.contains(child)) continue;
                list.add(child);
            }
        }
        return list;
    }

    public static void createEmptyContents(ModelBase base, ModelRenderer ori, ModelRenderer copy, int depth) {
        if (depth > 20) {
            return;
        }
        if (copy.field_78804_l.size() < ori.field_78804_l.size()) {
            for (int j = copy.field_78804_l.size(); j < ori.field_78804_l.size(); ++j) {
                ModelBox box = (ModelBox)ori.field_78804_l.get(j);
                float param7 = 0.0f;
                ModelBox randBox = (ModelBox)ori.field_78804_l.get(rand.nextInt(ori.field_78804_l.size()));
                float x = randBox.field_78252_a + (randBox.field_78248_d - randBox.field_78252_a > 0.0f ? (float)rand.nextInt((int)(randBox.field_78248_d - randBox.field_78252_a) > 0 ? (int)(randBox.field_78248_d - randBox.field_78252_a) : 1) : 0.0f);
                float y = randBox.field_78250_b + (randBox.field_78249_e - randBox.field_78250_b > 0.0f ? (float)rand.nextInt((int)(randBox.field_78249_e - randBox.field_78250_b) > 0 ? (int)(randBox.field_78249_e - randBox.field_78250_b) : 1) : 0.0f);
                float z = randBox.field_78251_c + (randBox.field_78246_f - randBox.field_78251_c > 0.0f ? (float)rand.nextInt((int)(randBox.field_78246_f - randBox.field_78251_c) > 0 ? (int)(randBox.field_78246_f - randBox.field_78251_c) : 1) : 0.0f);
                copy.func_78790_a(x, y, z, 0, 0, 0, param7);
            }
        }
        if (ori.field_78805_m != null && (copy.field_78805_m == null || copy.field_78805_m.size() < ori.field_78805_m.size())) {
            for (int i = 0; i < ori.field_78805_m.size(); ++i) {
                ModelRenderer childCopy = ModelHelper.buildCopy((ModelRenderer)ori.field_78805_m.get(i), base, 0, false);
                ModelHelper.createEmptyContents(base, (ModelRenderer)ori.field_78805_m.get(i), childCopy, depth + 1);
                copy.func_78792_a(childCopy);
            }
        }
    }

    public static ModelRenderer buildCopy(ModelRenderer original, ModelBase copyBase, int depth, boolean hasFullModelBox) {
        int txOffsetX = 0;
        int txOffsetY = 0;
        try {
            txOffsetX = (Integer)ObfuscationReflectionHelper.getPrivateValue(ModelRenderer.class, (Object)original, (String[])ObfHelper.textureOffsetX);
            txOffsetY = (Integer)ObfuscationReflectionHelper.getPrivateValue(ModelRenderer.class, (Object)original, (String[])ObfHelper.textureOffsetY);
        }
        catch (Exception e) {
            ObfHelper.obfWarning();
            e.printStackTrace();
        }
        ModelRenderer cubeCopy = new ModelRenderer(copyBase, txOffsetX, txOffsetY);
        cubeCopy.field_78809_i = original.field_78809_i;
        cubeCopy.field_78799_b = original.field_78799_b;
        cubeCopy.field_78801_a = original.field_78801_a;
        for (int j = 0; j < original.field_78804_l.size(); ++j) {
            ModelBox box = (ModelBox)original.field_78804_l.get(j);
            float param7 = 0.0f;
            if (hasFullModelBox) {
                cubeCopy.func_78789_a(box.field_78252_a, box.field_78250_b, box.field_78251_c, (int)Math.abs(box.field_78248_d - box.field_78252_a), (int)Math.abs(box.field_78249_e - box.field_78250_b), (int)Math.abs(box.field_78246_f - box.field_78251_c));
                continue;
            }
            ModelBox randBox = (ModelBox)original.field_78804_l.get(rand.nextInt(original.field_78804_l.size()));
            float x = randBox.field_78252_a + (randBox.field_78248_d - randBox.field_78252_a > 0.0f ? (float)rand.nextInt((int)(randBox.field_78248_d - randBox.field_78252_a) > 0 ? (int)(randBox.field_78248_d - randBox.field_78252_a) : 1) : 0.0f);
            float y = randBox.field_78250_b + (randBox.field_78249_e - randBox.field_78250_b > 0.0f ? (float)rand.nextInt((int)(randBox.field_78249_e - randBox.field_78250_b) > 0 ? (int)(randBox.field_78249_e - randBox.field_78250_b) : 1) : 0.0f);
            float z = randBox.field_78251_c + (randBox.field_78246_f - randBox.field_78251_c > 0.0f ? (float)rand.nextInt((int)(randBox.field_78246_f - randBox.field_78251_c) > 0 ? (int)(randBox.field_78246_f - randBox.field_78251_c) : 1) : 0.0f);
            cubeCopy.func_78789_a(x, y, z, (int)Math.abs(box.field_78248_d - box.field_78252_a), (int)Math.abs(box.field_78249_e - box.field_78250_b), (int)Math.abs(box.field_78246_f - box.field_78251_c));
        }
        if (original.field_78805_m != null && depth < 20) {
            for (int i = 0; i < original.field_78805_m.size(); ++i) {
                ModelRenderer child = (ModelRenderer)original.field_78805_m.get(i);
                cubeCopy.func_78792_a(ModelHelper.buildCopy(child, copyBase, depth + 1, hasFullModelBox));
            }
        }
        cubeCopy.func_78793_a(original.field_78800_c, original.field_78797_d, original.field_78798_e);
        cubeCopy.field_78795_f = original.field_78795_f;
        cubeCopy.field_78796_g = original.field_78796_g;
        cubeCopy.field_78808_h = original.field_78808_h;
        return cubeCopy;
    }

    public static int getModelHeight(ModelRenderer model) {
        int height = 0;
        for (int i = 0; i < model.field_78804_l.size(); ++i) {
            ModelBox box = (ModelBox)model.field_78804_l.get(i);
            if ((int)Math.abs(box.field_78249_e - box.field_78250_b) <= height) continue;
            height = (int)Math.abs(box.field_78249_e - box.field_78250_b);
        }
        return height;
    }

    public static ModelRenderer createMorphArm(ModelBase morph, ModelRenderer prevArm, ModelRenderer nextArm, int morphProgress, float renderTick) {
        int heightDiff;
        if (prevArm == null) {
            prevArm = new ModelRenderer(morph, 0, 0);
            prevArm.func_78790_a(-3.0f, -2.0f, -2.0f, 0, 12, 0, 0.0f);
            prevArm.func_78793_a(-5.0f, 2.0f, 0.0f);
        }
        if (nextArm == null) {
            nextArm = new ModelRenderer(morph, 0, 0);
            nextArm.func_78790_a(-3.0f, -2.0f, -2.0f, 0, 12, 0, 0.0f);
            nextArm.func_78793_a(-5.0f, 2.0f, 0.0f);
        }
        ModelRenderer cube = new ModelRenderer(morph, 0, 0);
        float mag = (float)Math.pow(((float)morphProgress - 10.0f + renderTick) / 50.0f, 2.0);
        cube.field_78809_i = nextArm.field_78809_i;
        if (mag > 1.0f) {
            mag = 1.0f;
        }
        for (int i = 0; i < nextArm.field_78804_l.size(); ++i) {
            ModelBox newBox = (ModelBox)nextArm.field_78804_l.get(i);
            ModelBox prevBox = null;
            if (i < prevArm.field_78804_l.size()) {
                prevBox = (ModelBox)prevArm.field_78804_l.get(i);
            }
            float nextXpos = 0.0f;
            float nextYpos = 0.0f;
            float nextZpos = 0.0f;
            float prevXpos = 0.0f;
            float prevYpos = 0.0f;
            float prevZpos = 0.0f;
            int newXSize = 0;
            int newYSize = 0;
            int newZSize = 0;
            int prevXSize = 0;
            int prevYSize = 0;
            int prevZSize = 0;
            if (newBox != null) {
                newXSize = (int)Math.abs(newBox.field_78248_d - newBox.field_78252_a);
                newYSize = (int)Math.abs(newBox.field_78249_e - newBox.field_78250_b);
                newZSize = (int)Math.abs(newBox.field_78246_f - newBox.field_78251_c);
                nextXpos = newBox.field_78252_a;
                nextYpos = newBox.field_78250_b;
                nextZpos = newBox.field_78251_c;
            }
            if (prevBox != null) {
                prevXSize = (int)Math.abs(prevBox.field_78248_d - prevBox.field_78252_a);
                prevYSize = (int)Math.abs(prevBox.field_78249_e - prevBox.field_78250_b);
                prevZSize = (int)Math.abs(prevBox.field_78246_f - prevBox.field_78251_c);
                prevXpos = prevBox.field_78252_a;
                prevYpos = prevBox.field_78250_b;
                prevZpos = prevBox.field_78251_c;
            }
            cube.func_78790_a(prevXpos + (nextXpos - prevXpos) * mag, prevYpos + (nextYpos - prevYpos) * mag, prevZpos + (nextZpos - prevZpos) * mag, Math.round((float)prevXSize + (float)(newXSize - prevXSize) * mag), Math.round((float)prevYSize + (float)(newYSize - prevYSize) * mag), Math.round((float)prevZSize + (float)(newZSize - prevZSize) * mag), 0.0f);
        }
        if (morphProgress <= 60) {
            heightDiff = 24 - ModelHelper.getModelHeight(prevArm) - ModelHelper.getModelHeight(nextArm);
            cube.field_78800_c = prevArm.field_78800_c + (nextArm.field_78800_c - prevArm.field_78800_c) * mag;
            cube.field_78797_d = prevArm.field_78797_d + (nextArm.field_78797_d - prevArm.field_78797_d) * mag + (float)heightDiff;
            cube.field_78798_e = prevArm.field_78798_e + (nextArm.field_78798_e - prevArm.field_78798_e) * mag;
        } else {
            heightDiff = 12 - ModelHelper.getModelHeight(nextArm);
            cube.field_78800_c = nextArm.field_78800_c;
            cube.field_78797_d = nextArm.field_78797_d + (float)heightDiff;
            cube.field_78798_e = nextArm.field_78798_e;
        }
        return cube;
    }

    public static ArrayList<ModelRenderer> compileRenderableModels(ModelInfo modelInfo, EntityLivingBase ent) {
        if (ent != null) {
            boolean forceRender = Morph.proxy.tickHandlerClient.forceRender;
            Morph.proxy.tickHandlerClient.forceRender = true;
            modelInfo.forceRender((Entity)ent, 0.0, -500.0, 0.0, 0.0f, 1.0f);
            ArrayList<ModelRenderer> modelList = ModelHelper.getModelCubes(ModelHelper.getPossibleModel(modelInfo.getRenderer()));
            for (int i = 0; i < modelList.size(); ++i) {
                ModelRenderer cube = modelList.get(i);
                try {
                    if (!((Boolean)ObfuscationReflectionHelper.getPrivateValue(ModelRenderer.class, (Object)cube, (String[])ObfHelper.compiled)).booleanValue()) continue;
                    GLAllocation.func_74523_b((int)((Integer)ObfuscationReflectionHelper.getPrivateValue(ModelRenderer.class, (Object)cube, (String[])ObfHelper.displayList)));
                    ObfuscationReflectionHelper.setPrivateValue(ModelRenderer.class, (Object)cube, (Object)false, (String[])ObfHelper.compiled);
                    continue;
                }
                catch (Exception e) {
                    ObfHelper.obfWarning();
                    e.printStackTrace();
                }
            }
            modelInfo.forceRender((Entity)ent, 0.0, -500.0, 0.0, 0.0f, 1.0f);
            Morph.proxy.tickHandlerClient.forceRender = forceRender;
            ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>(modelList);
            for (int i = list.size() - 1; i >= 0; --i) {
                ModelRenderer cube = list.get(i);
                try {
                    if (((Boolean)ObfuscationReflectionHelper.getPrivateValue(ModelRenderer.class, (Object)cube, (String[])ObfHelper.compiled)).booleanValue()) continue;
                    list.remove(i);
                    continue;
                }
                catch (Exception e) {
                    ObfHelper.obfWarning();
                    e.printStackTrace();
                }
            }
            return list;
        }
        return modelInfo.modelList;
    }
}

