/*
 * Decompiled with CFR 0.152.
 */
package com.demoxin.minecraft.moreenchants;

import com.demoxin.minecraft.moreenchants.MoreEnchants;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDigging;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentUntouching;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.oredict.OreDictionary;

public class Enchantment_Harvest
extends Enchantment {
    protected List<ItemStack> harvestableOres;

    protected Enchantment_Harvest(int par1, int par2) {
        super(par1, par2, EnumEnchantmentType.digger);
        this.func_77322_b("harvest");
        Enchantment_Harvest.addToBookList((Enchantment)this);
    }

    public void Prepare() {
        String[] oreDictNames;
        this.harvestableOres = new ArrayList<ItemStack>();
        for (String orename : oreDictNames = OreDictionary.getOreNames()) {
            if (!orename.contains("ore") && !orename.contains("gem") && !orename.contains("dust") && !orename.contains("crystal")) continue;
            ArrayList ores = OreDictionary.getOres((String)orename);
            for (ItemStack ore : ores) {
                if (this.harvestableOres.contains(ore)) continue;
                this.harvestableOres.add(ore);
            }
        }
        this.harvestableOres.add(new ItemStack(Items.field_151044_h));
        this.harvestableOres.add(new ItemStack(Items.field_151128_bU));
        this.harvestableOres.add(new ItemStack(Items.field_151114_aO));
        this.harvestableOres.add(new ItemStack(Items.field_151100_aR, 1, 4));
    }

    public int func_77321_a(int par1) {
        return 15;
    }

    public int func_77317_b(int par1) {
        return super.func_77321_a(par1) + 50;
    }

    public int func_77325_b() {
        return 1;
    }

    public boolean func_77326_a(Enchantment fTest) {
        return !(fTest instanceof EnchantmentDigging) && !(fTest instanceof EnchantmentUntouching);
    }

    public boolean func_92089_a(ItemStack fTest) {
        return fTest.func_77973_b() instanceof ItemPickaxe || fTest.func_77973_b() instanceof ItemAxe || fTest.func_77973_b() instanceof ItemHoe || fTest.func_77973_b() instanceof ItemBook;
    }

    @SubscribeEvent
    public void HandlePick(BlockEvent.HarvestDropsEvent fEvent) {
        if (fEvent.harvester == null) {
            return;
        }
        if (fEvent.block == Blocks.field_150348_b || fEvent.block == Blocks.field_150347_e || fEvent.block == Blocks.field_150424_aL || fEvent.block == Blocks.field_150377_bs) {
            return;
        }
        ItemStack harvestingItem = fEvent.harvester.func_71045_bC();
        if (harvestingItem == null) {
            return;
        }
        if (EnchantmentHelper.func_77506_a((int)MoreEnchants.enchantHarvest.field_77352_x, (ItemStack)harvestingItem) <= 0) {
            return;
        }
        int searchX = fEvent.x - 3;
        int searchY = fEvent.y - 3;
        int searchZ = fEvent.z - 3;
        ArrayList<Coords> breakBlocks = new ArrayList<Coords>();
        ArrayList testForOre = fEvent.block.getDrops(fEvent.world, searchX, searchY, searchZ, fEvent.blockMetadata, fEvent.fortuneLevel);
        ForgeEventFactory.fireBlockHarvesting((ArrayList)testForOre, (World)fEvent.world, (Block)fEvent.block, (int)searchX, (int)searchY, (int)searchZ, (int)fEvent.blockMetadata, (int)fEvent.fortuneLevel, (float)fEvent.dropChance, (boolean)false, null);
        boolean testOre = false;
        block0: for (ItemStack stack : testForOre) {
            for (ItemStack harvestable : this.harvestableOres) {
                if (!harvestable.func_77969_a(stack)) continue;
                testOre = true;
                continue block0;
            }
        }
        if (!testOre) {
            return;
        }
        int i = 0;
        while (i < 7) {
            searchY = fEvent.y - 3;
            int j = 0;
            while (j < 7) {
                searchZ = fEvent.z - 3;
                int k = 0;
                while (k < 7) {
                    Block block = fEvent.world.func_147439_a(searchX, searchY, searchZ);
                    int blockMeta = fEvent.world.func_72805_g(searchX, searchY, searchZ);
                    if (block != null) {
                        if (blockMeta < 0 || blockMeta > 15) {
                            blockMeta = 0;
                        }
                        ArrayList itemsDropped = block.getDrops(fEvent.world, searchX, searchY, searchZ, blockMeta, fEvent.fortuneLevel);
                        ForgeEventFactory.fireBlockHarvesting((ArrayList)itemsDropped, (World)fEvent.world, (Block)fEvent.block, (int)searchX, (int)searchY, (int)searchZ, (int)fEvent.blockMetadata, (int)fEvent.fortuneLevel, (float)fEvent.dropChance, (boolean)fEvent.isSilkTouching, null);
                        if (!itemsDropped.isEmpty()) {
                            block5: for (ItemStack item : itemsDropped) {
                                for (ItemStack testItem : fEvent.drops) {
                                    if (!OreDictionary.itemMatches((ItemStack)testItem, (ItemStack)item, (boolean)true)) continue;
                                    breakBlocks.add(new Coords(searchX, searchY, searchZ));
                                    break block5;
                                }
                            }
                        }
                    }
                    ++k;
                    ++searchZ;
                }
                ++j;
                ++searchY;
            }
            ++i;
            ++searchX;
        }
        if (breakBlocks.isEmpty()) {
            return;
        }
        float avgDrop = fEvent.dropChance;
        for (Coords targetBlock : breakBlocks) {
            ArrayList itemsToDrop = fEvent.block.getDrops(fEvent.world, targetBlock.x, targetBlock.y, targetBlock.z, fEvent.blockMetadata, fEvent.fortuneLevel);
            avgDrop += ForgeEventFactory.fireBlockHarvesting((ArrayList)itemsToDrop, (World)fEvent.world, (Block)fEvent.block, (int)targetBlock.x, (int)targetBlock.y, (int)targetBlock.z, (int)fEvent.blockMetadata, (int)fEvent.fortuneLevel, (float)fEvent.dropChance, (boolean)fEvent.isSilkTouching, null);
            for (ItemStack stack : itemsToDrop) {
                fEvent.drops.add(stack);
            }
            fEvent.world.func_147468_f(targetBlock.x, targetBlock.y, targetBlock.z);
        }
        fEvent.dropChance = avgDrop / (float)(breakBlocks.size() + 1);
        harvestingItem.func_77972_a(breakBlocks.size(), (EntityLivingBase)fEvent.harvester);
    }

    @SubscribeEvent
    public void HandleAxe(BlockEvent.HarvestDropsEvent fEvent) {
        if (fEvent.harvester == null) {
            return;
        }
        ItemStack harvestingItem = fEvent.harvester.func_71045_bC();
        if (harvestingItem == null || !(harvestingItem.func_77973_b() instanceof ItemAxe)) {
            return;
        }
        if (EnchantmentHelper.func_77506_a((int)MoreEnchants.enchantHarvest.field_77352_x, (ItemStack)harvestingItem) <= 0) {
            return;
        }
        Block blockObj = fEvent.block;
        if (blockObj == null) {
            return;
        }
        if (!blockObj.isWood((IBlockAccess)fEvent.world, fEvent.x, fEvent.y, fEvent.z)) {
            return;
        }
        boolean foundTop = false;
        int searchHeight = fEvent.y;
        for (int i = 1; i <= 50; ++i) {
            searchHeight = fEvent.y + i;
            Block search = fEvent.world.func_147439_a(fEvent.x, searchHeight, fEvent.z);
            if (search == blockObj) continue;
            foundTop = true;
            break;
        }
        if (!foundTop) {
            return;
        }
        int numLeaves = 0;
        for (int searchX = fEvent.x - 1; searchX <= fEvent.x + 1; ++searchX) {
            for (int searchY = searchHeight - 1; searchY <= searchHeight + 2; ++searchY) {
                for (int searchZ = fEvent.z - 1; searchZ <= fEvent.z + 1; ++searchZ) {
                    Block searchLeaves = fEvent.world.func_147439_a(searchX, searchY, searchZ);
                    if (searchLeaves == null || !searchLeaves.isLeaves((IBlockAccess)fEvent.world, searchX, searchY, searchZ)) continue;
                    ++numLeaves;
                }
            }
        }
        if (numLeaves < 3) {
            return;
        }
        ArrayList<Object> drops = new ArrayList();
        fEvent.world.func_147465_d(fEvent.x, fEvent.y, fEvent.z, fEvent.block, fEvent.blockMetadata, 2);
        drops = this.BreakTree(fEvent.world, fEvent.x, fEvent.y, fEvent.z, fEvent.fortuneLevel, fEvent.dropChance, fEvent.x, fEvent.z);
        fEvent.drops.clear();
        fEvent.drops.addAll(drops);
    }

    protected ArrayList<ItemStack> BreakTree(World fWorld, int fX, int fY, int fZ, int fFortune, float fChance, int fOriginX, int fOriginZ) {
        ArrayList<Coords> listCoords = new ArrayList<Coords>();
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        listCoords.add(new Coords(fX - 1, fY, fZ));
        listCoords.add(new Coords(fX + 1, fY, fZ));
        listCoords.add(new Coords(fX, fY, fZ - 1));
        listCoords.add(new Coords(fX, fY, fZ + 1));
        listCoords.add(new Coords(fX, fY + 1, fZ));
        listCoords.add(new Coords(fX - 1, fY, fZ - 1));
        listCoords.add(new Coords(fX + 1, fY, fZ - 1));
        listCoords.add(new Coords(fX - 1, fY, fZ + 1));
        listCoords.add(new Coords(fX + 1, fY, fZ + 1));
        Block centerBlockObj = fWorld.func_147439_a(fX, fY, fZ);
        int centerBlockMeta = fWorld.func_72805_g(fX, fY, fZ);
        if (!centerBlockObj.isToolEffective("axe", centerBlockMeta)) {
            return drops;
        }
        int centerHarvestLevel = centerBlockObj.getHarvestLevel(centerBlockMeta);
        ArrayList itemsToDrop = centerBlockObj.getDrops(fWorld, fX, fY, fZ, centerBlockMeta, fFortune);
        ForgeEventFactory.fireBlockHarvesting((ArrayList)itemsToDrop, (World)fWorld, (Block)centerBlockObj, (int)fX, (int)fY, (int)fZ, (int)centerBlockMeta, (int)fFortune, (float)fChance, (boolean)false, null);
        for (ItemStack stack : itemsToDrop) {
            drops.add(stack);
        }
        fWorld.func_147468_f(fX, fY, fZ);
        for (Coords checkCoord : listCoords) {
            int blockMeta;
            Block blockObj = fWorld.func_147439_a(checkCoord.x, checkCoord.y, checkCoord.z);
            if (blockObj == null || !blockObj.isToolEffective("axe", blockMeta = fWorld.func_72805_g(checkCoord.x, checkCoord.y, checkCoord.z)) || blockObj.getHarvestLevel(blockMeta) > centerHarvestLevel || !blockObj.isWood((IBlockAccess)fWorld, checkCoord.x, checkCoord.y, checkCoord.z) && !blockObj.isLeaves((IBlockAccess)fWorld, checkCoord.x, checkCoord.y, checkCoord.z) || checkCoord.x >= fOriginX + 4 || checkCoord.x <= fOriginX - 4 || checkCoord.z >= fOriginZ + 4 || checkCoord.z <= fOriginZ - 4) continue;
            drops.addAll(this.BreakTree(fWorld, checkCoord.x, checkCoord.y, checkCoord.z, fFortune, fChance, fOriginX, fOriginZ));
        }
        Block blockBelow = fWorld.func_147439_a(fX, fY - 1, fZ);
        if (blockBelow != null && blockBelow.isLeaves((IBlockAccess)fWorld, fX, fY - 1, fZ)) {
            drops.addAll(this.BreakTree(fWorld, fX, fY - 1, fZ, fFortune, fChance, fOriginX, fOriginZ));
        }
        return drops;
    }

    @SubscribeEvent
    public void HandleHoe(BlockEvent.HarvestDropsEvent fEvent) {
        if (fEvent.harvester == null) {
            return;
        }
        ItemStack harvestingItem = fEvent.harvester.func_71045_bC();
        if (harvestingItem == null) {
            return;
        }
        if (EnchantmentHelper.func_77506_a((int)MoreEnchants.enchantHarvest.field_77352_x, (ItemStack)harvestingItem) <= 0) {
            return;
        }
        if (fEvent.block.func_149688_o() != Material.field_151585_k) {
            return;
        }
        int searchX = fEvent.x - 2;
        int searchY = fEvent.y;
        int searchZ = fEvent.z - 2;
        float avgDrop = fEvent.dropChance;
        boolean brokenBlocks = false;
        int i = 0;
        while (i < 5) {
            searchZ = fEvent.z - 3;
            int j = 0;
            while (j < 5) {
                Block block = fEvent.world.func_147439_a(searchX, searchY, searchZ);
                int blockMeta = fEvent.world.func_72805_g(searchX, searchY, searchZ);
                if (block != null) {
                    if (blockMeta < 0 || blockMeta > 15) {
                        blockMeta = 0;
                    }
                    if (block.func_149688_o() == Material.field_151585_k) {
                        ArrayList itemsDropped = block.getDrops(fEvent.world, searchX, searchY, searchZ, blockMeta, fEvent.fortuneLevel);
                        ForgeEventFactory.fireBlockHarvesting((ArrayList)itemsDropped, (World)fEvent.world, (Block)fEvent.block, (int)searchX, (int)searchY, (int)searchZ, (int)fEvent.blockMetadata, (int)fEvent.fortuneLevel, (float)fEvent.dropChance, (boolean)fEvent.isSilkTouching, null);
                        if (!itemsDropped.isEmpty()) {
                            ArrayList itemsToDrop = fEvent.block.getDrops(fEvent.world, searchX, searchY, searchZ, blockMeta, fEvent.fortuneLevel);
                            avgDrop += ForgeEventFactory.fireBlockHarvesting((ArrayList)itemsToDrop, (World)fEvent.world, (Block)fEvent.block, (int)searchX, (int)searchY, (int)searchZ, (int)blockMeta, (int)fEvent.fortuneLevel, (float)fEvent.dropChance, (boolean)fEvent.isSilkTouching, null);
                            for (ItemStack stack : itemsToDrop) {
                                fEvent.drops.add(stack);
                            }
                            fEvent.world.func_147468_f(searchX, searchY, searchZ);
                        }
                    }
                }
                ++j;
                ++searchZ;
            }
            ++i;
            ++searchX;
        }
        fEvent.dropChance = avgDrop / (float)brokenBlocks + 1.0f;
    }

    @SubscribeEvent
    public void HandleHoe(UseHoeEvent fEvent) {
        if (!fEvent.entityPlayer.func_82247_a(fEvent.x, fEvent.y, fEvent.z, fEvent.world.func_72805_g(fEvent.x, fEvent.y, fEvent.z), fEvent.current)) {
            return;
        }
        if (fEvent.current == null) {
            return;
        }
        if (EnchantmentHelper.func_77506_a((int)MoreEnchants.enchantHarvest.field_77352_x, (ItemStack)fEvent.current) <= 0) {
            return;
        }
        Block blockTarget = fEvent.world.func_147439_a(fEvent.x, fEvent.y, fEvent.z);
        if (blockTarget == null) {
            return;
        }
        if (blockTarget.func_149688_o() != Material.field_151572_C) {
            return;
        }
        Block block = fEvent.world.func_147439_a(fEvent.x, fEvent.y, fEvent.z);
        int blockMeta = fEvent.world.func_72805_g(fEvent.x, fEvent.y, fEvent.z);
        if (block == null) {
            return;
        }
        if (blockMeta < 0 || blockMeta > 15) {
            blockMeta = 0;
        }
        block.func_149697_b(fEvent.world, fEvent.x, fEvent.y, fEvent.z, blockMeta, 0);
        fEvent.world.func_147468_f(fEvent.x, fEvent.y, fEvent.z);
    }

    protected class Coords {
        public int x;
        public int y;
        public int z;

        Coords(int fX, int fY, int fZ) {
            this.x = fX;
            this.y = fY;
            this.z = fZ;
        }
    }
}

