/*
 * Decompiled with CFR 0.152.
 */
package monstergirlmod.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import monstergirlmod.EntityAICreeperDespairSwell;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityCreeperDespair
extends EntityMob {
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 4;

    public EntityCreeperDespair(World par1) {
        super(par1);
        this.field_70728_aV = 45;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAICreeperDespairSwell(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.37);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    public boolean func_70650_aV() {
        return true;
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + MathHelper.func_76123_f((float)(this.func_110143_aJ() - 1.0f));
    }

    protected void func_70069_a(float par1) {
        super.func_70069_a(par1);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + par1 * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)-1);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        if (this.field_70180_af.func_75683_a(17) == 1) {
            par1NBTTagCompound.func_74757_a("powered", true);
        }
        par1NBTTagCompound.func_74777_a("Fuse", (short)this.fuseTime);
        par1NBTTagCompound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        par1NBTTagCompound.func_74757_a("ignited", this.func_146078_ca());
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.field_70180_af.func_75692_b(17, (Object)((byte)(par1NBTTagCompound.func_74767_n("powered") ? 1 : 0)));
        if (par1NBTTagCompound.func_150297_b("Fuse", 99)) {
            this.fuseTime = par1NBTTagCompound.func_74765_d("Fuse");
        }
        if (par1NBTTagCompound.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = par1NBTTagCompound.func_74771_c("ExplosionRadius");
        }
        if (par1NBTTagCompound.func_74767_n("ignited")) {
            this.func_146079_cb();
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.func_146078_ca()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_85030_a("creeper.primed", 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.func_146077_cc();
            }
        }
        super.func_70071_h_();
    }

    protected String func_70621_aR() {
        return "mob.creeper.say";
    }

    protected String func_70673_aS() {
        return "mob.creeper.death";
    }

    protected Item func_146068_u() {
        return Items.field_151016_H;
    }

    protected void func_70628_a(boolean var1, int var2) {
        super.func_70628_a(var1, var2);
        if (this.field_70146_Z.nextFloat() <= 0.25f + 0.1f * (float)var2) {
            this.func_145779_a(Items.field_151059_bz, 1);
        }
        if (this.field_70146_Z.nextFloat() <= 0.175f + 0.1f * (float)var2) {
            this.func_145779_a(new ItemStack(Blocks.field_150343_Z, 1, 0).func_77973_b(), 1);
        }
        if (this.field_70146_Z.nextFloat() <= 0.1f + 0.1f * (float)var2) {
            this.func_145779_a(new ItemStack(Items.field_151153_ao, 1, 0).func_77973_b(), 1);
        }
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (par1DamageSource.func_76346_g() instanceof EntitySkeleton) {
            int i = Item.func_150891_b((Item)Items.field_151096_cd);
            int j = Item.func_150891_b((Item)Items.field_151084_co);
            int k = i + this.field_70146_Z.nextInt(j - i + 1);
            this.func_145779_a(Item.func_150899_d((int)k), 1);
        }
    }

    public boolean func_70652_k(Entity par1Entity) {
        return true;
    }

    public boolean getPowered() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    public int getCreeperState() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setCreeperState(int par1) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)par1));
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float par1) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * par1) / (float)(this.fuseTime - 2);
    }

    public void func_70077_a(EntityLightningBolt par1EntityLightningBolt) {
        super.func_70077_a(par1EntityLightningBolt);
        this.field_70180_af.func_75692_b(17, (Object)1);
    }

    protected boolean func_70085_c(EntityPlayer par1EntityPlayer) {
        ItemStack itemstack = par1EntityPlayer.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "fire.ignite", 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            par1EntityPlayer.func_71038_i();
            if (!this.field_70170_p.field_72995_K) {
                this.func_146079_cb();
                itemstack.func_77972_a(1, (EntityLivingBase)par1EntityPlayer);
                return true;
            }
        }
        return super.func_70085_c(par1EntityPlayer);
    }

    private void func_146077_cc() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            double d1 = (double)this.explosionRadius + 1.25;
            if (this.getPowered()) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)(this.explosionRadius * 2), flag);
                d1 *= 2.0;
            } else {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionRadius, flag);
            }
            Entity hitEntity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(d1, d1, d1));
            for (int I1 = 0; I1 < list.size(); ++I1) {
                hitEntity = (Entity)list.get(I1);
                if (!(hitEntity instanceof EntityLivingBase)) continue;
                EntityLivingBase target = (EntityLivingBase)hitEntity;
                target.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 600, 0));
                target.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 160, 2));
                target.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 100, 0));
                target.func_70015_d(5);
            }
            this.func_70106_y();
        }
    }

    public boolean func_146078_ca() {
        return this.field_70180_af.func_75683_a(18) != 0;
    }

    public void func_146079_cb() {
        this.field_70180_af.func_75692_b(18, (Object)1);
    }
}

