package tsuteto.snowsdeeper.asm;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import net.minecraft.launchwrapper.IClassTransformer;

public class Transformer implements IClassTransformer
{
    private static final String TARGET_CLASS_NAME = "net.minecraft.block.BlockSnow";

    public Transformer()
    {
    }

    @Override
    public byte[] transform(String actual, String transformed, byte[] bytes)
    {
        if (!TARGET_CLASS_NAME.equals(transformed))
        {
            return bytes;
        }

        try
        {
            //System.out.println("Snow Deeper replacing class...");
            return replaceClass(bytes);
        }
        catch (Exception e)
        {
            throw new RuntimeException("failed : Transformer loading", e);
        }
    }

    private byte[] replaceClass(byte[] bytes) throws IOException
    {
        ZipFile zf = null;
        InputStream zi = null;

        try
        {
            System.out.println("from " + SnowsDeeperCorePlugin.location);
            zf = new ZipFile(SnowsDeeperCorePlugin.location);

            ZipEntry ze = zf.getEntry("bin/BlockSnow.bin");

            if (ze != null)
            {
                zi = zf.getInputStream(ze);
                bytes = new byte[(int) ze.getSize()];
                zi.read(bytes);
                //System.out.println("-> Success");
            }
            else
            {
                //System.out.println("-> No file found");
            }

            return bytes;
        }
        finally
        {
            if (zi != null)
            {
                zi.close();
            }

            if (zf != null)
            {
                zf.close();
            }
        }
    }
}
