/*
 * Decompiled with CFR 0.152.
 */
package me.ghosrec35.mpc.nbt;

import java.util.HashMap;
import java.util.Map;
import me.ghosrec35.mpc.nbt.NBTBasedSaveFile;
import me.ghosrec35.mpc.nbt.SaveFileUtilities;
import me.ghosrec35.mpc.util.WorldCoordinates;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class MPCWorldDataManager {
    public Map<String, WorldCoordinates> warpList = new HashMap<String, WorldCoordinates>();
    private NBTBasedSaveFile worldDataFile;

    public MPCWorldDataManager(String worldName, String dataFileName) {
        this.worldDataFile = SaveFileUtilities.buildNBTSaveFile(worldName, dataFileName);
        this.loadWarpList();
    }

    private void loadWarpList() {
        NBTTagCompound nbtEntry = this.worldDataFile.getData();
        this.loadWarpEntries(nbtEntry);
    }

    public void loadWarpEntries(NBTTagCompound tag) {
        NBTTagList warpNames = tag.func_150295_c("WarpNames", 8);
        NBTTagList warpLocations = tag.func_150295_c("WarpLocations", 8);
        assert (warpNames.func_74745_c() == warpLocations.func_74745_c()) : "An error ocurred with Warps! Please report this to the mod author!";
        this.warpList.clear();
        for (int i = 0; i < warpNames.func_74745_c(); ++i) {
            String warpName = warpNames.func_150305_b(i).func_74779_i("WarpName");
            int[] warpLocation = warpLocations.func_150305_b(i).func_74759_k("WarpLocations");
            this.warpList.put(warpName, new WorldCoordinates(warpLocation[0], warpLocation[1], warpLocation[2]));
        }
    }

    public void addWarpEntry(String warpName, int x, int y, int z) {
        NBTTagCompound tag = this.worldDataFile.getData();
        NBTTagList warpNames = tag.func_150295_c("WarpNames", 8);
        NBTTagList warpLocations = tag.func_150295_c("WarpLocations", 8);
        warpNames.func_74742_a((NBTBase)new NBTTagString(warpName));
        warpLocations.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{x, y, z}));
        tag.func_74782_a("WarpNames", (NBTBase)warpNames);
        tag.func_74782_a("WarpLocations", (NBTBase)warpLocations);
        this.loadWarpEntries(tag);
    }

    public void removeWarpEntry(String warpName) {
        NBTTagCompound tag = this.worldDataFile.getData();
        NBTTagList warpNames = tag.func_150295_c("WarpNames", 8);
        NBTTagList warpLocations = tag.func_150295_c("WarpLocations", 8);
        for (int i = 0; i < warpNames.func_74745_c(); ++i) {
            warpNames.func_150305_b(i).func_82580_o("WarpName");
            warpLocations.func_150305_b(i).func_82580_o("WarpLocation");
        }
        tag.func_74782_a("WarpNames", (NBTBase)warpNames);
        tag.func_74782_a("WarpLocations", (NBTBase)warpLocations);
        this.loadWarpEntries(tag);
    }
}

