/*
 * Decompiled with CFR 0.152.
 */
package me.ghosrec35.mpc.asm;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import me.ghosrec35.mpc.asm.BaseMethodVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMHelper {
    public static ClassNode createClassNode(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        return cn;
    }

    public static ClassNode createClassNode(String classpath) {
        try {
            ClassReader cr = new ClassReader(ASMHelper.class.getResourceAsStream(classpath));
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            return cn;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static MethodNode getMethodNode(ClassNode cn, String methodName) {
        for (MethodNode method : cn.methods) {
            if (!method.name.equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static FieldNode getFieldNode(ClassNode cn, String fieldName) {
        for (FieldNode field : cn.fields) {
            if (!field.name.equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static AnnotationNode getAnnotationNode(ClassNode cn, String annotationName) {
        for (AnnotationNode annotation : cn.visibleAnnotations) {
            if (!annotation.getClass().getSimpleName().equals(annotationName)) continue;
            return annotation;
        }
        for (AnnotationNode annotation : cn.invisibleAnnotations) {
            if (!annotation.getClass().getSimpleName().equals(annotationName)) continue;
            return annotation;
        }
        return null;
    }

    public static InnerClassNode getInnerClassNode(ClassNode cn, String innerClassName) {
        for (InnerClassNode innerClass : cn.innerClasses) {
            if (!innerClass.name.equals(innerClassName)) continue;
            return innerClass;
        }
        return null;
    }

    public static ClassNode getOuterClassNode(ClassNode cn) {
        if (cn.outerClass == null) {
            return null;
        }
        try {
            Class<?> outerClass = Class.forName(cn.outerClass);
            ClassReader cr = new ClassReader(ASMHelper.class.getResourceAsStream(cn.outerClass));
            ClassNode outerCN = new ClassNode();
            cr.accept((ClassVisitor)outerCN, 0);
            return outerCN;
        }
        catch (ClassNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ClassNode getSuperClassNode(ClassNode cn) {
        if (cn.superName == null) {
            return null;
        }
        try {
            Class<?> outerClass = Class.forName(cn.superName);
            ClassReader cr = new ClassReader(ASMHelper.class.getResourceAsStream(cn.superName));
            ClassNode outerCN = new ClassNode();
            cr.accept((ClassVisitor)outerCN, 0);
            return outerCN;
        }
        catch (ClassNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean checkClassSignature(ClassNode cn, Class<?>[] signature) {
        boolean isMatch = true;
        String[] classnames = cn.signature.split(":");
        Class<?>[] clazzes = ASMHelper.getClassesFromPaths(classnames);
        if (clazzes.length == signature.length) {
            for (int i = 0; i < signature.length; ++i) {
                if (clazzes[i].equals(signature[i])) continue;
                isMatch = false;
            }
        }
        return isMatch;
    }

    private static Class<?>[] getClassesFromPaths(String[] classpaths) {
        ArrayList classes = new ArrayList();
        for (String classPath : classpaths) {
            try {
                classes.add(Class.forName(classPath));
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static byte[] injectHook(byte[] originalClassBytes, BaseMethodVisitor visitor, String methodName, String methodDesc, String classPath) {
        ClassReader cr = new ClassReader(originalClassBytes);
        ClassWriter cv = new ClassWriter(0);
        cr.accept((ClassVisitor)cv, 0);
        return cv.toByteArray();
    }
}

