/*
 * Decompiled with CFR 0.152.
 */
package me.ghosrec35.mpc.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Random;
import me.ghosrec35.mpc.nbt.ExtendedPlayerData;
import me.ghosrec35.mpc.ref.MPCReflectionHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class EventManager {
    private Random rand = new Random();

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        EntityPlayer oldPlayer = event.entityPlayer;
        EntityPlayer newPlayer = event.original;
        if (oldPlayer.getExtendedProperties("MPCommandsPlayerData") != null) {
            try {
                Field f = MPCReflectionHelper.getClassField("extendedProperties", newPlayer);
                if (f != null) {
                    f.setAccessible(true);
                    HashMap newPropMap = (HashMap)f.get(newPlayer);
                    IExtendedEntityProperties props = oldPlayer.getExtendedProperties("MPCommandsPlayerData");
                    newPropMap.put("MPCommandsPlayerData", props);
                    props.init((Entity)newPlayer, newPlayer.field_70170_p);
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerFall(LivingFallEvent event) {
        ExtendedPlayerData data;
        if (event.entityLiving instanceof EntityPlayer && (data = (ExtendedPlayerData)((EntityPlayer)event.entityLiving).getExtendedProperties("MPCommandsPlayerData")).isFallDamageInactive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerAttemptBlockHarvest(PlayerInteractEvent event) {
        ExtendedPlayerData data;
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && (data = (ExtendedPlayerData)event.entityPlayer.getExtendedProperties("MPCommandsPlayerData")).isInstaMineActive()) {
            Block block = event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z);
            event.entityPlayer.field_70170_p.func_147468_f(event.x, event.y, event.z);
            ItemStack stack = new ItemStack(block.func_149650_a(0, this.rand, 0));
            EntityItem item = new EntityItem(event.entityPlayer.field_70170_p, (double)event.x, (double)event.y, (double)event.z, stack);
            event.entityPlayer.field_70170_p.func_72838_d((Entity)item);
        }
    }

    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent event) {
        ExtendedPlayerData data = (ExtendedPlayerData)event.entityPlayer.getExtendedProperties("MPCommandsPlayerData");
        if (data.isInstaKillActive()) {
            System.out.println("Is in fact executing.");
            if (event.target instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)event.target;
                living.func_70097_a(DamageSource.func_76365_a((EntityPlayer)event.entityPlayer), living.func_110143_aJ());
            } else {
                event.target.func_70106_y();
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ExtendedPlayerData data = (ExtendedPlayerData)player.getExtendedProperties("MPCommandsPlayerData");
            NBTTagCompound tag = new NBTTagCompound();
            data.saveNBTData(tag);
            NBTTagCompound compound = (NBTTagCompound)tag.func_74781_a("MPCommandsPlayerData");
            compound.func_74780_a("LastDeathPosX", player.field_70165_t);
            compound.func_74780_a("LastDeathPosY", player.field_70163_u);
            compound.func_74780_a("LastDeathPosZ", player.field_70161_v);
            tag.func_74782_a("MPCommandsPlayerData", (NBTBase)compound);
            data.loadNBTData(tag);
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingHurtEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (player.field_71075_bZ.field_75102_a) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstruction(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            event.entity.registerExtendedProperties("MPCommandsPlayerData", (IExtendedEntityProperties)new ExtendedPlayerData((EntityPlayer)event.entity));
        }
    }
}

