/*
 * Decompiled with CFR 0.152.
 */
package net.epoxide.mpc.util;

import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class StackUtils {
    private static final UUID toolUUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");

    public static ItemStack prepareStackTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack;
    }

    public static ItemStack setHealthAttribute(ItemStack stack, double amount, int type) {
        StackUtils.setAttributeForStack(stack, SharedMonsterAttributes.field_111267_a.func_111108_a(), "Tool modifier", amount, type);
        return stack;
    }

    public static double getHealthAttribute(ItemStack stack) {
        return StackUtils.getAttributeForStack(stack, SharedMonsterAttributes.field_111267_a.func_111108_a());
    }

    public static ItemStack setKnockbackResistanceAttribute(ItemStack stack, double amount, int type) {
        StackUtils.setAttributeForStack(stack, SharedMonsterAttributes.field_111266_c.func_111108_a(), "Tool modifier", amount, type);
        return stack;
    }

    public static double getKnockbackResistanceAttribute(ItemStack stack) {
        return StackUtils.getAttributeForStack(stack, SharedMonsterAttributes.field_111266_c.func_111108_a());
    }

    public static ItemStack setFollowAttribute(ItemStack stack, double amount, int type) {
        StackUtils.setAttributeForStack(stack, SharedMonsterAttributes.field_111265_b.func_111108_a(), "Tool modifier", amount, type);
        return stack;
    }

    public static double getFollowAttribute(ItemStack stack) {
        return StackUtils.getAttributeForStack(stack, SharedMonsterAttributes.field_111265_b.func_111108_a());
    }

    public static ItemStack setSpeedAttribute(ItemStack stack, double amount, int type) {
        StackUtils.setAttributeForStack(stack, SharedMonsterAttributes.field_111263_d.func_111108_a(), "Tool modifier", amount, type);
        return stack;
    }

    public static double getSpeedAttribute(ItemStack stack) {
        return StackUtils.getAttributeForStack(stack, SharedMonsterAttributes.field_111267_a.func_111108_a());
    }

    public static ItemStack setDamageAttribute(ItemStack stack, double amount, int type) {
        StackUtils.setAttributeForStack(stack, SharedMonsterAttributes.field_111264_e.func_111108_a(), "Weapon modifier", amount, type);
        return stack;
    }

    public static double getDamageAttribute(ItemStack stack) {
        return StackUtils.getAttributeForStack(stack, SharedMonsterAttributes.field_111267_a.func_111108_a());
    }

    public static ItemStack setAttributeForStack(ItemStack stack, String atbName, String name, double amount, int operation) {
        NBTTagList list = stack.field_77990_d.func_74764_b("AttributeModifiers") ? stack.field_77990_d.func_150295_c("AttributeModifiers", 10) : new NBTTagList();
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("AttributeName", atbName);
        tag.func_74778_a("Name", name);
        tag.func_74780_a("Amount", amount);
        tag.func_74768_a("Operation", operation);
        tag.func_74772_a("UUIDMost", toolUUID.getMostSignificantBits());
        tag.func_74772_a("UUIDLeast", toolUUID.getLeastSignificantBits());
        list.func_74742_a((NBTBase)tag);
        stack.field_77990_d.func_74782_a("AttributeModifiers", (NBTBase)list);
        return stack;
    }

    public static double getAttributeForStack(ItemStack stack, String atbName) {
        NBTTagList list = stack.field_77990_d.func_150295_c("AttributeModifiers", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            if (!tag.func_74764_b("AttributeName") || !tag.func_74779_i("AttributeName").equals(atbName)) continue;
            return tag.func_74769_h("Amount");
        }
        System.out.println("There was an error retrieving the " + atbName + " Attribute from the " + stack.func_82833_r() + " 0.00 was returned");
        return 0.0;
    }

    public static double getItemWeaponDamage(ItemStack stack) {
        Multimap multimap = stack.func_111283_C();
        if (multimap.containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()) && multimap.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()).toArray().length > 0 && multimap.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()).toArray()[0] instanceof AttributeModifier) {
            AttributeModifier weaponModifier = (AttributeModifier)multimap.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()).toArray()[0];
            return weaponModifier.func_111164_d();
        }
        return 0.0;
    }
}

