/*
 * Decompiled with CFR 0.152.
 */
package net.epoxide.mpc;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.epoxide.mpc.GroupManager;
import net.epoxide.mpc.PlayerFile;
import net.epoxide.mpc.command.CommandAddItem;
import net.epoxide.mpc.command.CommandAddTab;
import net.epoxide.mpc.command.CommandBroadcast;
import net.epoxide.mpc.command.CommandCraft;
import net.epoxide.mpc.command.CommandDamage;
import net.epoxide.mpc.command.CommandDelItem;
import net.epoxide.mpc.command.CommandDelTab;
import net.epoxide.mpc.command.CommandDrop;
import net.epoxide.mpc.command.CommandDropAll;
import net.epoxide.mpc.command.CommandEnchant;
import net.epoxide.mpc.command.CommandFilledChest;
import net.epoxide.mpc.command.CommandFly;
import net.epoxide.mpc.command.CommandGod;
import net.epoxide.mpc.command.CommandHat;
import net.epoxide.mpc.command.CommandHeal;
import net.epoxide.mpc.command.CommandHome;
import net.epoxide.mpc.command.CommandHunger;
import net.epoxide.mpc.command.CommandInstaKill;
import net.epoxide.mpc.command.CommandInstaMine;
import net.epoxide.mpc.command.CommandItem;
import net.epoxide.mpc.command.CommandItemAttribute;
import net.epoxide.mpc.command.CommandKillAll;
import net.epoxide.mpc.command.CommandLift;
import net.epoxide.mpc.command.CommandLore;
import net.epoxide.mpc.command.CommandMPC;
import net.epoxide.mpc.command.CommandMPCBase;
import net.epoxide.mpc.command.CommandMaxHealth;
import net.epoxide.mpc.command.CommandRename;
import net.epoxide.mpc.command.CommandRepair;
import net.epoxide.mpc.command.CommandSeeInventory;
import net.epoxide.mpc.command.CommandSetHome;
import net.epoxide.mpc.command.CommandSmelt;
import net.epoxide.mpc.command.CommandSpawner;
import net.epoxide.mpc.command.CommandSpeed;
import net.epoxide.mpc.event.EventManager;
import net.epoxide.mpc.nbt.MPCWorldDataManager;
import net.epoxide.mpc.ref.ConfigurationData;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="MultiplayerCommands", name="Multiplayer Commands", version="0.0.0.1-SNAPSHOT")
public class MultiplayerCommands {
    @Mod.Instance(value="MultiplayerCommands")
    public static MultiplayerCommands instance;
    public static final String MOD_ID = "MultiplayerCommands";
    public static final String MOD_NAME = "Multiplayer Commands";
    public static final String MOD_VERSION = "0.0.0.1-SNAPSHOT";
    public static HashMap<String, Class<? extends Entity>> entityMap;
    public static Map<String, Enchantment> enchantmentMap;
    public static Map<String, ICommand> commandMap;
    public MPCWorldDataManager dataManager;
    public boolean usesGroupFile;
    public GroupManager manager;
    public Map<String, PlayerFile> customPlayerCommandFiles = new HashMap<String, PlayerFile>();
    private MinecraftServer minecraft;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(new File(event.getModConfigurationDirectory(), "MPC Configs/" + event.getModMetadata().name + ".cfg"));
        config.load();
        ConfigurationData.setConfigValues(config);
        config.save();
        this.manager = new GroupManager(new File(event.getModConfigurationDirectory(), "MPC Configs/UserGroups.cfg"));
        File dir = new File(event.getModConfigurationDirectory(), "MPC Configs/user-files");
        if (!dir.isDirectory()) {
            return;
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        for (File file : dir.listFiles()) {
            if (file.getName().endsWith(".cfg")) {
                this.customPlayerCommandFiles.put(file.getName().replace(".cfg", ""), new PlayerFile(file));
                continue;
            }
            file.delete();
        }
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventManager());
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        this.dataManager = new MPCWorldDataManager(event.getServer().func_71221_J(), "mpc_data.dat");
        ServerCommandManager manager = (ServerCommandManager)event.getServer().func_71187_D();
        manager.func_71560_a((ICommand)new CommandKillAll());
        manager.func_71560_a((ICommand)new CommandDropAll());
        manager.func_71560_a((ICommand)new CommandEnchant());
        manager.func_71560_a((ICommand)new CommandRename());
        manager.func_71560_a((ICommand)new CommandLore());
        manager.func_71560_a((ICommand)new CommandRepair());
        manager.func_71560_a((ICommand)new CommandDamage());
        manager.func_71560_a((ICommand)new CommandLift());
        manager.func_71560_a((ICommand)new CommandDrop());
        manager.func_71560_a((ICommand)new CommandHeal());
        manager.func_71560_a((ICommand)new CommandHunger());
        manager.func_71560_a((ICommand)new CommandSetHome());
        manager.func_71560_a((ICommand)new CommandHome());
        manager.func_71560_a((ICommand)new CommandSeeInventory());
        manager.func_71560_a((ICommand)new CommandSpawner());
        manager.func_71560_a((ICommand)new CommandGod());
        manager.func_71560_a((ICommand)new CommandFly());
        manager.func_71560_a((ICommand)new CommandMaxHealth());
        manager.func_71560_a((ICommand)new CommandSpeed());
        manager.func_71560_a((ICommand)new CommandBroadcast());
        manager.func_71560_a((ICommand)new CommandAddTab());
        manager.func_71560_a((ICommand)new CommandDelTab());
        manager.func_71560_a((ICommand)new CommandAddItem());
        manager.func_71560_a((ICommand)new CommandDelItem());
        manager.func_71560_a((ICommand)new CommandItem());
        manager.func_71560_a((ICommand)new CommandSmelt());
        manager.func_71560_a((ICommand)new CommandInstaKill());
        manager.func_71560_a((ICommand)new CommandCraft());
        manager.func_71560_a((ICommand)new CommandHat());
        manager.func_71560_a((ICommand)new CommandInstaMine());
        manager.func_71560_a((ICommand)new CommandItemAttribute());
        manager.func_71560_a((ICommand)new CommandMPC());
        manager.func_71560_a((ICommand)new CommandFilledChest());
        for (ICommand command : manager.func_71555_a().values()) {
            if (!(command instanceof CommandMPCBase)) continue;
            String commandKey = "mpc." + command.func_71517_b();
            commandMap.put(commandKey, command);
        }
    }

    private static String genEntityCommandKey(String className) {
        String[] entityNameParts = className.toLowerCase().split("\\.");
        String entityName = entityNameParts[entityNameParts.length - 1].replaceAll("entity", "");
        System.out.println(entityName);
        return entityName;
    }

    static {
        entityMap = new HashMap();
        enchantmentMap = new HashMap<String, Enchantment>();
        commandMap = new HashMap<String, ICommand>();
        for (Class entityClass : EntityList.field_75625_b.values()) {
            entityMap.put(MultiplayerCommands.genEntityCommandKey(entityClass.getName()), entityClass);
        }
        for (Enchantment enchant : Enchantment.field_77331_b) {
            if (enchant == null) continue;
            enchantmentMap.put(enchant.func_77320_a().toLowerCase(), enchant);
        }
        List modList = Loader.instance().getActiveModList();
        for (ModContainer modContainer : modList) {
        }
    }
}

