/*
 * Decompiled with CFR 0.152.
 */
package net.epoxide.mpc.nbt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTBasedSaveFile {
    private File fileToSave;

    public NBTBasedSaveFile(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.fileToSave = file;
    }

    public void addData(String key, Object data) {
        NBTTagCompound tag = this.getData();
        this.writeToTag(tag, key, data);
        try {
            FileOutputStream fos = new FileOutputStream(this.fileToSave);
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)fos);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addData(NBTTagCompound tag) {
        try {
            FileOutputStream fos = new FileOutputStream(this.fileToSave);
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)fos);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public NBTTagCompound getData() {
        try {
            FileInputStream fis = new FileInputStream(this.fileToSave);
            NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)fis);
            fis.close();
            return tag;
        }
        catch (IOException e) {
            try {
                FileOutputStream fos = new FileOutputStream(this.fileToSave);
                CompressedStreamTools.func_74799_a((NBTTagCompound)new NBTTagCompound(), (OutputStream)fos);
                fos.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return this.getData();
        }
    }

    private void writeToTag(NBTTagCompound tag, String key, Object data) {
        if (data instanceof Integer) {
            tag.func_74768_a(key, ((Integer)data).intValue());
        } else if (data instanceof Byte) {
            tag.func_74774_a(key, ((Byte)data).byteValue());
        } else if (data instanceof byte[]) {
            tag.func_74773_a(key, (byte[])data);
        } else if (data instanceof Double) {
            tag.func_74780_a(key, ((Double)data).doubleValue());
        } else if (data instanceof Float) {
            tag.func_74776_a(key, ((Float)data).floatValue());
        } else if (data instanceof int[]) {
            tag.func_74783_a(key, (int[])data);
        } else if (data instanceof NBTTagList) {
            tag.func_74782_a(key, (NBTBase)((NBTTagList)data));
        } else if (data instanceof Long) {
            tag.func_74772_a(key, ((Long)data).longValue());
        } else if (data instanceof Short) {
            tag.func_74777_a(key, ((Short)data).shortValue());
        } else if (data instanceof String) {
            tag.func_74778_a(key, (String)data);
        }
    }

    public String toString() {
        return this.fileToSave.getAbsolutePath();
    }
}

