/*
 * Decompiled with CFR 0.152.
 */
package net.epoxide.mpc.nbt;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendedPlayerData
implements IExtendedEntityProperties {
    public static final String EXTENDED_PROPS_IDENT = "MPCommandsPlayerData";
    private double playerHomeX;
    private double playerHomeY;
    private double playerHomeZ;
    private double lastDeathPosX;
    private double lastDeathPosY;
    private double lastDeathPosZ;
    private double lastPosX;
    private double lastPosY;
    private double lastPosZ;
    private boolean instaKillActive;
    private boolean instaMineActive;
    private boolean fallDamageInactive;
    private boolean iceAura;
    private EntityPlayer player;

    public ExtendedPlayerData(EntityPlayer entityPlayer) {
        this.player = entityPlayer;
        this.playerHomeX = this.player.field_70165_t;
        this.playerHomeY = this.player.field_70163_u;
        this.playerHomeZ = this.player.field_70161_v;
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74780_a("PlayerHomeX", this.playerHomeX);
        tag.func_74780_a("PlayerHomeY", this.playerHomeY);
        tag.func_74780_a("PlayerHomeZ", this.playerHomeZ);
        tag.func_74780_a("LastDeathPosX", this.lastDeathPosX);
        tag.func_74780_a("LastDeathPosY", this.lastDeathPosY);
        tag.func_74780_a("LastDeathPosZ", this.lastDeathPosZ);
        tag.func_74780_a("LastPositionX", this.lastPosX);
        tag.func_74780_a("LastPositionY", this.lastPosY);
        tag.func_74780_a("LastPositionZ", this.lastPosZ);
        tag.func_74757_a("InstaKill", this.instaKillActive);
        tag.func_74757_a("InstaMine", this.instaMineActive);
        tag.func_74757_a("FallDamage", this.fallDamageInactive);
        compound.func_74782_a(EXTENDED_PROPS_IDENT, (NBTBase)tag);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound props = (NBTTagCompound)compound.func_74781_a(EXTENDED_PROPS_IDENT);
        this.playerHomeX = props.func_74769_h("PlayerHomeX");
        this.playerHomeY = props.func_74769_h("PlayerHomeY");
        this.playerHomeZ = props.func_74769_h("PlayerHomeZ");
        this.lastDeathPosX = props.func_74769_h("LastDeathPosX");
        this.lastDeathPosY = props.func_74769_h("LastDeathPosY");
        this.lastDeathPosZ = props.func_74769_h("LastDeathPosZ");
        this.lastPosX = props.func_74769_h("LastPositionX");
        this.lastPosY = props.func_74769_h("LastPositionY");
        this.lastPosZ = props.func_74769_h("LastPositionZ");
        this.instaKillActive = props.func_74767_n("InstaKill");
        this.instaMineActive = props.func_74767_n("InstaMine");
        this.fallDamageInactive = props.func_74767_n("FallDamage");
    }

    public void init(Entity entity, World world) {
    }

    public double getHomeXCoordinate() {
        return this.playerHomeX;
    }

    public double getHomeYCoordinate() {
        return this.playerHomeY;
    }

    public double getHomeZCoordinate() {
        return this.playerHomeZ;
    }

    public double getDeathXCoordinate() {
        return this.lastDeathPosX;
    }

    public double getDeathYCoordinate() {
        return this.lastDeathPosY;
    }

    public double getDeathZCoordinate() {
        return this.lastDeathPosZ;
    }

    public double getBackXCoordinate() {
        return this.lastPosX;
    }

    public double getBackYCoordinate() {
        return this.lastPosY;
    }

    public double getBackZCoordinate() {
        return this.lastPosZ;
    }

    public boolean isIceAuraActivated() {
        return this.iceAura;
    }

    public boolean isInstaKillActive() {
        return this.instaKillActive;
    }

    public boolean isInstaMineActive() {
        return this.instaMineActive;
    }

    public boolean isFallDamageInactive() {
        return this.fallDamageInactive;
    }
}

