/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.packets;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.meteor.common.ClientHandler;
import net.meteor.common.climate.GhostMeteor;
import net.meteor.common.packets.AbstractPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;

public class PacketSoonestMeteor
extends AbstractPacket {
    private ChunkCoordinates soonestMeteorLoc;

    public PacketSoonestMeteor() {
    }

    public PacketSoonestMeteor(GhostMeteor gMeteor) {
        this.soonestMeteorLoc = gMeteor != null ? new ChunkCoordinates(gMeteor.x, 0, gMeteor.z) : new ChunkCoordinates(-1, -1, -1);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.soonestMeteorLoc.field_71574_a);
        buffer.writeInt(this.soonestMeteorLoc.field_71572_b);
        buffer.writeInt(this.soonestMeteorLoc.field_71573_c);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        this.soonestMeteorLoc = y == -1 ? null : new ChunkCoordinates(x, y, z);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        ClientHandler.nearestTimeLocation = this.soonestMeteorLoc;
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

