/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.packets;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.meteor.common.ClientHandler;
import net.meteor.common.climate.CrashLocation;
import net.meteor.common.packets.AbstractPacket;
import net.minecraft.entity.player.EntityPlayer;

public class PacketLastCrash
extends AbstractPacket {
    private CrashLocation lastCrashLoc;

    public PacketLastCrash() {
    }

    public PacketLastCrash(CrashLocation loc) {
        this.lastCrashLoc = loc;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.lastCrashLoc.x);
        buffer.writeInt(this.lastCrashLoc.y);
        buffer.writeInt(this.lastCrashLoc.z);
        buffer.writeBoolean(this.lastCrashLoc.inOrbit);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        boolean inOrbit = buffer.readBoolean();
        this.lastCrashLoc = x == -1 && y == -1 && z == -1 ? (ClientHandler.lastCrashLocation != null ? ClientHandler.lastCrashLocation.prevCrash : null) : new CrashLocation(x, y, z, inOrbit, ClientHandler.lastCrashLocation);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        ClientHandler.lastCrashLocation = this.lastCrashLoc;
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

