/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.packets;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.Random;
import net.meteor.common.EnumMeteor;
import net.meteor.common.MeteorsMod;
import net.meteor.common.packets.AbstractPacket;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class PacketBlockedMeteor
extends AbstractPacket {
    private int x;
    private int y;
    private int z;
    private EnumMeteor type;

    public PacketBlockedMeteor() {
    }

    public PacketBlockedMeteor(int x, int y, int z, EnumMeteor type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeInt(this.type.getID());
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.type = EnumMeteor.getTypeFromID(buffer.readInt());
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        Block block = this.type.getRepresentingBlock();
        World world = player.field_70170_p;
        double d3 = Math.min(0.8666667f, 10.0f);
        if (d3 > 2.5) {
            d3 = 2.5;
        }
        int l1 = (int)(150.0 * d3);
        for (int i2 = 0; i2 < l1; ++i2) {
            float f3 = MathHelper.func_151240_a((Random)world.field_73012_v, (float)0.0f, (float)((float)Math.PI * 2));
            double d5 = MathHelper.func_151240_a((Random)world.field_73012_v, (float)0.75f, (float)1.0f);
            double d6 = (double)0.2f + d3 / 100.0;
            double d7 = (double)(MathHelper.func_76134_b((float)f3) * 0.2f) * d5 * d5 * (d3 + 0.2);
            double d8 = (double)(MathHelper.func_76126_a((float)f3) * 0.2f) * d5 * d5 * (d3 + 0.2);
            world.func_72869_a("blockcrack_" + Block.func_149682_b((Block)block) + "_1", (double)((float)this.x + 0.5f), (double)((float)this.y + 1.0f), (double)((float)this.z + 0.5f), d7, d6, d8);
            MeteorsMod.log.info("Particle should've spawned");
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

