/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.meteor.common.ClientHandler;
import net.meteor.common.EnumMeteor;
import net.meteor.common.HandlerAchievement;
import net.meteor.common.IMeteorShield;
import net.meteor.common.MeteorsMod;
import net.meteor.common.climate.CrashLocation;
import net.meteor.common.climate.GhostMeteor;
import net.meteor.common.climate.HandlerMeteor;
import net.meteor.common.crash.CrashFrezarite;
import net.meteor.common.crash.CrashKitty;
import net.meteor.common.crash.CrashKreknorite;
import net.meteor.common.crash.CrashMeteorite;
import net.meteor.common.crash.CrashUnknown;
import net.meteor.common.packets.PacketLastCrash;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityMeteor
extends Entity
implements IEntityAdditionalSpawnData {
    public int size = 1;
    public EnumMeteor meteorType;
    public int spawnPauseTicks = 0;
    private int originX;
    private int originZ;
    protected boolean summoned = false;

    public EntityMeteor(World world) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.98f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.meteorType = EnumMeteor.METEORITE;
        this.field_70159_w = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 1.2;
        this.field_70179_y = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 1.2;
        this.field_70177_z = (float)(Math.random() * 360.0);
        this.field_70125_A = (float)(Math.random() * 360.0);
    }

    public EntityMeteor(World world, int mSize, double x, double z, EnumMeteor metType, boolean summon) {
        this(world);
        this.size = mSize;
        this.meteorType = metType;
        this.summoned = summon;
        this.originX = (int)x;
        this.originZ = (int)z;
        this.func_70107_b(x, 250.0, z);
        this.field_70169_q = x;
        this.field_70167_r = 250.0;
        this.field_70166_s = z;
    }

    protected void func_70088_a() {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        HandlerMeteor metHandler;
        IMeteorShield shield;
        if (!this.summoned && !this.field_70170_p.field_72995_K && (shield = (metHandler = MeteorsMod.proxy.metHandlers.get(this.field_70170_p.field_73011_w.field_76574_g)).getShieldManager().getClosestShieldInRange((int)this.field_70165_t, (int)this.field_70161_v)) != null) {
            String owner = shield.getOwner();
            EntityPlayerMP playerOwner = ((WorldServer)this.field_70170_p).func_73046_m().func_71203_ab().func_152612_a(owner);
            if (playerOwner != null) {
                playerOwner.func_145747_a(ClientHandler.createMessage(StatCollector.func_74838_a((String)"MeteorShield.meteorBlocked"), EnumChatFormatting.GREEN));
                playerOwner.func_71064_a((StatBase)HandlerAchievement.meteorBlocked, 1);
            }
            metHandler.getShieldManager().sendMeteorMaterialsToShield(shield, new GhostMeteor((int)this.field_70165_t, (int)this.field_70161_v, this.size, 0, this.meteorType));
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.explode", 5.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
            CrashLocation lastCrash = metHandler.getForecast().getLastCrashLocation();
            if (lastCrash != null && lastCrash.x == this.originX && lastCrash.z == this.originZ) {
                metHandler.getForecast().setLastCrashLocation(null);
                MeteorsMod.packetPipeline.sendToDimension(new PacketLastCrash(new CrashLocation(-1, -1, -1, false, null)), this.field_70170_p.field_73011_w.field_76574_g);
            }
            this.func_70106_y();
            return;
        }
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.field_70125_A = (float)(((double)this.field_70125_A + 3.0) % 360.0);
        this.field_70177_z = (float)(((double)this.field_70125_A + 3.0) % 360.0);
        if (this.spawnPauseTicks > 0) {
            --this.spawnPauseTicks;
            return;
        }
        if (this.summoned) {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= (double)0.04f;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70181_x *= (double)0.98f;
        if (this.field_70122_E) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                CrashMeteorite worldGen;
                if (!this.summoned) {
                    CrashLocation cc;
                    AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(this.field_70165_t - 40.0), (double)(this.field_70163_u - 20.0), (double)(this.field_70161_v - 40.0), (double)(this.field_70165_t + 40.0), (double)(this.field_70163_u + 20.0), (double)(this.field_70161_v + 40.0));
                    List players = this.field_70170_p.func_72872_a(EntityPlayer.class, aabb);
                    for (int i = 0; i < players.size(); ++i) {
                        EntityPlayer player = (EntityPlayer)players.get(i);
                        player.func_71064_a((StatBase)HandlerAchievement.foundMeteor, 1);
                    }
                    HandlerMeteor metHandler2 = MeteorsMod.proxy.metHandlers.get(this.field_70170_p.field_73011_w.field_76574_g);
                    if (metHandler2 != null && (cc = metHandler2.getForecast().getLastCrashLocation()) != null && this.originX == cc.x && this.originZ == cc.z) {
                        metHandler2.getForecast().setLastCrashLocation(new CrashLocation((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, false, cc.prevCrash));
                        MeteorsMod.packetPipeline.sendToDimension(new PacketLastCrash(metHandler2.getForecast().getLastCrashLocation()), this.field_70170_p.field_73011_w.field_76574_g);
                    }
                }
                if ((worldGen = this.getWorldGen()).func_76484_a(this.field_70170_p, this.field_70146_Z, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v)) {
                    worldGen.afterCrashCompleted(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
                }
            }
        } else if (this.size == 1) {
            this.field_70170_p.func_72869_a("largeexplode", this.field_70165_t, this.field_70163_u + 2.75, this.field_70161_v, 0.0, 0.0, 0.0);
        } else {
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t, this.field_70163_u + 4.0, this.field_70161_v, 0.0, 0.0, 0.0);
        }
    }

    protected Explosion explode() {
        float f = (float)((double)this.size * MeteorsMod.instance.ImpactExplosionMultiplier);
        return this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, f, this.meteorType.getFieryExplosion(), true);
    }

    protected CrashMeteorite getWorldGen() {
        switch (this.meteorType.getID()) {
            case 0: {
                return new CrashMeteorite(this.size, this.explode(), this.meteorType);
            }
            case 1: {
                return new CrashFrezarite(this.size, this.explode(), this.meteorType);
            }
            case 2: {
                return new CrashKreknorite(this.size, this.explode(), this.meteorType);
            }
            case 3: {
                return new CrashUnknown(this.size, this.explode(), this.meteorType);
            }
            case 4: {
                return new CrashKitty(this.size, this.explode(), this.meteorType);
            }
        }
        return new CrashMeteorite(this.size, this.explode(), this.meteorType);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("size", this.size);
        nbttagcompound.func_74757_a("summoned", this.summoned);
        nbttagcompound.func_74768_a("metTypeID", this.meteorType.getID());
        nbttagcompound.func_74768_a("pauseTicks", this.spawnPauseTicks);
        nbttagcompound.func_74768_a("originX", this.originX);
        nbttagcompound.func_74768_a("originZ", this.originZ);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        this.size = nbttagcompound.func_74762_e("size");
        this.summoned = nbttagcompound.func_74767_n("summoned");
        this.meteorType = EnumMeteor.getTypeFromID(nbttagcompound.func_74762_e("metTypeID"));
        this.spawnPauseTicks = nbttagcompound.func_74762_e("pauseTicks");
        this.originX = nbttagcompound.func_74762_e("originX");
        this.originZ = nbttagcompound.func_74762_e("originZ");
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.meteorType.getID());
        buffer.writeInt(this.size);
        buffer.writeInt(this.spawnPauseTicks);
        buffer.writeBoolean(this.summoned);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.meteorType = EnumMeteor.getTypeFromID(additionalData.readInt());
        this.size = additionalData.readInt();
        this.spawnPauseTicks = additionalData.readInt();
        this.summoned = additionalData.readBoolean();
    }
}

