/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.crash;

import java.util.ArrayList;
import java.util.Random;
import net.meteor.common.EnumMeteor;
import net.meteor.common.MeteorsMod;
import net.meteor.common.entity.EntityAlienCreeper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class CrashMeteorite
extends WorldGenerator {
    protected int crashSize;
    protected Explosion explosion;
    protected EnumMeteor meteorType;

    public CrashMeteorite(int Size, Explosion expl, EnumMeteor metType) {
        this.crashSize = MathHelper.func_76125_a((int)Size, (int)1, (int)3);
        this.explosion = expl;
        this.meteorType = metType;
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        Block theBlock;
        int startZ;
        int startX;
        int y;
        Block meteor = this.meteorType.getMaterial();
        Block rareMeteor = this.meteorType.getRareMaterial();
        for (y = j + MeteorsMod.instance.ImpactSpread * this.crashSize; y >= j - MeteorsMod.instance.ImpactSpread * this.crashSize; --y) {
            for (startX = i + MeteorsMod.instance.ImpactSpread * this.crashSize; startX >= i - MeteorsMod.instance.ImpactSpread * this.crashSize; --startX) {
                for (startZ = k + MeteorsMod.instance.ImpactSpread * this.crashSize; startZ >= k - MeteorsMod.instance.ImpactSpread * this.crashSize; --startZ) {
                    if (world.func_147437_c(startX, y, startZ) || this.meteorsAboveAndBelow(world, startX, y, startZ) != 0 || random.nextInt(10) + 1 <= 7 || !this.checkBlockIDs(world, startX, y, startZ)) continue;
                    Block block = theBlock = random.nextInt(45) == 25 ? rareMeteor : meteor;
                    if (Block.func_149680_a((Block)theBlock, (Block)Blocks.field_150432_aD) || Block.func_149680_a((Block)theBlock, (Block)Blocks.field_150353_l)) {
                        world.func_147465_d(startX, y, startZ, theBlock, 0, 2);
                        continue;
                    }
                    world.func_147465_d(startX, y, startZ, theBlock, random.nextInt(4) + 1, 3);
                }
            }
        }
        for (y = j - MeteorsMod.instance.ImpactSpread * this.crashSize; y >= j - (MeteorsMod.instance.ImpactSpread * this.crashSize + 1); --y) {
            for (startX = i + MeteorsMod.instance.ImpactSpread * this.crashSize; startX >= i - MeteorsMod.instance.ImpactSpread * this.crashSize; --startX) {
                for (startZ = k + MeteorsMod.instance.ImpactSpread * this.crashSize; startZ >= k - MeteorsMod.instance.ImpactSpread * this.crashSize; --startZ) {
                    if (world.func_147437_c(startX, y, startZ) || this.meteorsAboveAndBelow(world, startX, y, startZ) != 0 || !this.checkBlockIDs(world, startX, y, startZ)) continue;
                    Block block = theBlock = random.nextInt(45) == 25 ? rareMeteor : meteor;
                    if (Block.func_149680_a((Block)theBlock, (Block)Blocks.field_150432_aD) || Block.func_149680_a((Block)theBlock, (Block)Blocks.field_150353_l)) {
                        world.func_147465_d(startX, y, startZ, theBlock, 0, 2);
                        continue;
                    }
                    world.func_147465_d(startX, y, startZ, theBlock, random.nextInt(4) + 1, 3);
                }
            }
        }
        this.afterCraterFormed(world, random, i, j, k);
        return true;
    }

    public void afterCraterFormed(World world, Random random, int i, int j, int k) {
        int aliencreepers = random.nextInt(5);
        ArrayList arraylist = new ArrayList();
        arraylist.addAll(this.explosion.field_77281_g);
        for (int j1 = arraylist.size() - 1; j1 >= 0 && aliencreepers > 0; --j1) {
            ChunkPosition chunkposition1 = (ChunkPosition)arraylist.get(j1);
            int l = chunkposition1.field_151329_a;
            int j11 = chunkposition1.field_151327_b;
            int l1 = chunkposition1.field_151328_c;
            boolean j2 = world.func_147437_c(l, j11, l1);
            Block k2 = world.func_147439_a(l, j11 - 1, l1);
            if (!j2 || !k2.func_149662_c() || random.nextInt(10) <= 4) continue;
            EntityAlienCreeper creeper = new EntityAlienCreeper(world);
            creeper.func_70012_b(l, j11, l1, 0.0f, 0.0f);
            world.func_72838_d((Entity)creeper);
            --aliencreepers;
        }
    }

    public void afterCrashCompleted(World world, int i, int j, int k) {
    }

    public int meteorsAbove(World world, int x, int y, int z) {
        int ceiling = y + 6 * this.crashSize;
        int mAbove = 0;
        for (int y1 = y; y1 <= ceiling; ++y1) {
            Block block = world.func_147439_a(x, y1, z);
            if (!Block.func_149680_a((Block)block, (Block)this.meteorType.getMaterial()) && !Block.func_149680_a((Block)block, (Block)this.meteorType.getRareMaterial())) continue;
            ++mAbove;
        }
        return mAbove;
    }

    public int meteorsBelow(World world, int x, int y, int z) {
        int floor = y - 6 * this.crashSize;
        int mBelow = 0;
        for (int y1 = y; y1 >= floor; --y1) {
            Block block = world.func_147439_a(x, y1, z);
            if (!Block.func_149680_a((Block)block, (Block)this.meteorType.getMaterial()) && !Block.func_149680_a((Block)block, (Block)this.meteorType.getRareMaterial())) continue;
            ++mBelow;
        }
        return mBelow;
    }

    public int meteorsAboveAndBelow(World world, int x, int y, int z) {
        Block bl = world.func_147439_a(x, y, z);
        return 0 - (Block.func_149680_a((Block)bl, (Block)this.meteorType.getRareMaterial()) ? 1 : this.meteorsAbove(world, x, y, z) + this.meteorsBelow(world, x, y, z) - (Block.func_149680_a((Block)bl, (Block)this.meteorType.getMaterial()) ? 1 : 0));
    }

    protected boolean checkBlockIDs(World world, int i, int j, int k) {
        Block bl = world.func_147439_a(i, j, k);
        return !Block.func_149680_a((Block)bl, (Block)Blocks.field_150357_h) && !Block.func_149680_a((Block)bl, (Block)this.meteorType.getMaterial()) && !Block.func_149680_a((Block)bl, (Block)this.meteorType.getRareMaterial()) && !Block.func_149680_a((Block)bl, (Block)Blocks.field_150358_i) && !Block.func_149680_a((Block)bl, (Block)Blocks.field_150355_j);
    }
}

