/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.climate;

import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.meteor.common.IMeteorShield;
import net.meteor.common.MeteorItems;
import net.meteor.common.MeteorsMod;
import net.meteor.common.climate.GhostMeteor;
import net.meteor.common.climate.MeteorShieldSavedData;
import net.meteor.common.crash.CrashUnknown;
import net.meteor.common.entity.EntityCometKitty;
import net.meteor.common.packets.PacketBlockedMeteor;
import net.meteor.common.tileentity.TileEntityMeteorShield;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ShieldManager {
    private World theWorld;
    private MeteorShieldSavedData shieldSavedData;
    private static Random random = new Random();
    public ArrayList<IMeteorShield> meteorShields = new ArrayList();

    public ShieldManager(World w) {
        this.theWorld = w;
        this.shieldSavedData = MeteorShieldSavedData.forWorld(this.theWorld, this);
    }

    public void addShield(IMeteorShield shield) {
        for (int i = 0; i < this.meteorShields.size(); ++i) {
            IMeteorShield shield2 = this.meteorShields.get(i);
            if (!shield.equals(shield2)) continue;
            this.meteorShields.remove(i);
            this.meteorShields.add(shield);
            return;
        }
        this.meteorShields.add(shield);
    }

    public IMeteorShield getClosestShield(int x, int z) {
        Iterator<IMeteorShield> iter = this.meteorShields.iterator();
        IMeteorShield closest = null;
        double distance = -1.0;
        while (iter.hasNext()) {
            IMeteorShield shield = iter.next();
            if (closest == null) {
                closest = shield;
                distance = this.getDistance(x, z, shield.getX(), shield.getZ());
                continue;
            }
            double d = this.getDistance(x, z, shield.getX(), shield.getZ());
            if (!(d < distance)) continue;
            distance = d;
            closest = shield;
        }
        return closest;
    }

    public IMeteorShield getClosestShieldInRange(int x, int z) {
        IMeteorShield shield = this.getClosestShield(x, z);
        if (shield != null) {
            double distance = this.getDistance(x, z, shield.getX(), shield.getZ());
            return distance <= (double)shield.getRange() ? shield : null;
        }
        return null;
    }

    public List<IMeteorShield> getShieldsInRange(int x, int z) {
        ArrayList<IMeteorShield> shields = new ArrayList<IMeteorShield>();
        for (IMeteorShield shield : this.meteorShields) {
            double d = this.getDistance(x, z, shield.getX(), shield.getZ());
            if (!(d <= (double)shield.getRange())) continue;
            shields.add(shield);
        }
        return shields;
    }

    public void sendMeteorMaterialsToShield(IMeteorShield shield, GhostMeteor gMeteor) {
        TileEntityMeteorShield tShield = (TileEntityMeteorShield)this.theWorld.func_147438_o(shield.getX(), shield.getY(), shield.getZ());
        if (tShield != null) {
            MeteorsMod.packetPipeline.sendToAllAround(new PacketBlockedMeteor(shield.getX(), shield.getY(), shield.getZ(), gMeteor.type), new NetworkRegistry.TargetPoint(this.theWorld.field_73011_w.field_76574_g, (double)shield.getX(), (double)shield.getY(), (double)shield.getZ(), 64.0));
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            int r = random.nextInt(100);
            switch (gMeteor.type.getID()) {
                case 0: {
                    items.add(new ItemStack(MeteorItems.itemMeteorChips, random.nextInt(4 * gMeteor.size) + 1));
                    if (r >= 15) break;
                    items.add(new ItemStack(MeteorItems.itemRedMeteorGem, random.nextInt(2 * gMeteor.size) + 1));
                    break;
                }
                case 1: {
                    items.add(new ItemStack(MeteorItems.itemFrezaCrystal, random.nextInt(4 * gMeteor.size) + 1));
                    if (r >= 20) break;
                    items.add(new ItemStack(Blocks.field_150432_aD, random.nextInt(3 * gMeteor.size) + 1));
                    break;
                }
                case 2: {
                    items.add(new ItemStack(MeteorItems.itemKreknoChip, random.nextInt(3 * gMeteor.size) + 1));
                    if (gMeteor.size < MeteorsMod.instance.MinMeteorSizeForPortal) break;
                    if (r < 20) {
                        items.add(new ItemStack(Items.field_151130_bT, random.nextInt(4 * gMeteor.size) + 1));
                    }
                    if (r >= 10) break;
                    items.add(new ItemStack(Items.field_151114_aO, random.nextInt(3 * gMeteor.size) + 1));
                    break;
                }
                case 3: {
                    ItemStack stack;
                    if (r < 50) {
                        items.add(new ItemStack(Items.field_151114_aO, random.nextInt(5 * gMeteor.size) + 1));
                    }
                    if (r < 75) {
                        int r2 = random.nextInt(3);
                        if (r2 == 0) {
                            items.add(new ItemStack(MeteorItems.itemMeteorChips, random.nextInt(4) + 1));
                        } else if (r2 == 1) {
                            items.add(new ItemStack(MeteorItems.itemFrezaCrystal, random.nextInt(4) + 1));
                        } else {
                            items.add(new ItemStack(MeteorItems.itemKreknoChip, random.nextInt(4) + 1));
                        }
                    }
                    if (r < 20 && (stack = CrashUnknown.getRandomLoot(random)) != null) {
                        items.add(stack);
                    }
                    if (r >= 5 || (stack = CrashUnknown.getRandomLoot(random)) == null) break;
                    items.add(stack);
                    break;
                }
                case 4: {
                    items.add(new ItemStack(Items.field_151101_aQ, random.nextInt(2 * gMeteor.size) + 1));
                    if (r >= 5) break;
                    items.add(new ItemStack(Items.field_151063_bx, 1, EntityList.func_75619_a((Entity)new EntityCometKitty(this.theWorld))));
                }
            }
            tShield.addMeteorMaterials(items);
        }
    }

    private double getDistance(int x1, int z1, int x2, int z2) {
        int x = x1 - x2;
        int z = z1 - z2;
        return MathHelper.func_76133_a((double)(x * x + z * z));
    }
}

