/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.climate;

import net.meteor.common.IMeteorShield;
import net.meteor.common.climate.MeteorShieldData;
import net.meteor.common.climate.ShieldManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;

public class MeteorShieldSavedData
extends WorldSavedData {
    private static final String key = "meteorShields";
    private static ShieldManager tempHandle;
    private ShieldManager manager;
    private boolean loaded = false;

    public MeteorShieldSavedData(String s) {
        super(s);
    }

    public static MeteorShieldSavedData forWorld(World world, ShieldManager man) {
        tempHandle = man;
        MapStorage storage = world.perWorldStorage;
        MeteorShieldSavedData result = (MeteorShieldSavedData)storage.func_75742_a(MeteorShieldSavedData.class, key);
        if (result == null) {
            result = new MeteorShieldSavedData(key);
            storage.func_75745_a(key, (WorldSavedData)result);
        }
        result.manager = man;
        tempHandle = null;
        return result;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        if (this.loaded) {
            return;
        }
        if (this.manager == null) {
            this.manager = tempHandle;
        }
        int numShields = nbt.func_74762_e("numShields");
        for (int i = 0; i < numShields; ++i) {
            NBTTagCompound sNBT = nbt.func_74775_l("s" + i);
            int x = sNBT.func_74762_e("x");
            int y = sNBT.func_74762_e("y");
            int z = sNBT.func_74762_e("z");
            int power = sNBT.func_74762_e("power");
            String owner = sNBT.func_74779_i("owner");
            this.manager.addShield(new MeteorShieldData(x, y, z, power, owner));
        }
        this.loaded = true;
    }

    public void func_76187_b(NBTTagCompound nbt) {
        int numShields = this.manager.meteorShields.size();
        nbt.func_74768_a("numShields", numShields);
        for (int i = 0; i < numShields; ++i) {
            NBTTagCompound sNBT = new NBTTagCompound();
            IMeteorShield shield = this.manager.meteorShields.get(i);
            sNBT.func_74768_a("x", shield.getX());
            sNBT.func_74768_a("y", shield.getY());
            sNBT.func_74768_a("z", shield.getZ());
            sNBT.func_74768_a("power", shield.getPowerLevel());
            sNBT.func_74778_a("owner", shield.getOwner());
            nbt.func_74782_a("s" + i, (NBTBase)sNBT);
        }
    }

    public boolean func_76188_b() {
        return true;
    }
}

