/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.climate;

import java.io.Serializable;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.ChunkCoordIntPair;

public class CrashedChunkSet
implements Serializable {
    private int[] theChunksX = new int[49];
    private int[] theChunksZ = new int[49];
    private int xChunkOrigin;
    private int zChunkOrigin;
    private int xOrigin;
    private int yOrigin;
    private int zOrigin;
    public int age;

    public CrashedChunkSet(int xChunkOrigin, int zChunkOrigin, int xPosOrigin, int yPosOrigin, int zPosOrigin) {
        int i = 0;
        for (int x = xChunkOrigin - 3; x <= xChunkOrigin + 3; ++x) {
            int z = zChunkOrigin - 3;
            while (z <= zChunkOrigin + 3) {
                this.theChunksX[i] = x;
                this.theChunksZ[i] = z++;
                ++i;
            }
        }
        this.xChunkOrigin = xChunkOrigin;
        this.zChunkOrigin = zChunkOrigin;
        this.xOrigin = xPosOrigin;
        this.yOrigin = yPosOrigin;
        this.zOrigin = zPosOrigin;
        this.age = 0;
    }

    public boolean containsChunk(ChunkCoordIntPair coords) {
        for (int i = 0; i < 49; ++i) {
            if (coords.field_77276_a != this.theChunksX[i] || coords.field_77275_b != this.theChunksZ[i]) continue;
            return true;
        }
        return false;
    }

    public ChunkCoordinates getCrashCoords() {
        return new ChunkCoordinates(this.xOrigin, this.yOrigin, this.zOrigin);
    }

    public String toString() {
        return this.xChunkOrigin + ":" + this.zChunkOrigin + ":" + this.xOrigin + ":" + this.yOrigin + ":" + this.zOrigin + ":" + this.age;
    }

    public static CrashedChunkSet fromNBTString(String s) {
        String[] props = s.split(":");
        if (props == null || props.length < 6) {
            return null;
        }
        int xcOrigin = Integer.parseInt(props[0]);
        int zcOrigin = Integer.parseInt(props[1]);
        int xOrigin = Integer.parseInt(props[2]);
        int yOrigin = Integer.parseInt(props[3]);
        int zOrigin = Integer.parseInt(props[4]);
        int age = Integer.parseInt(props[5]);
        CrashedChunkSet ccSet = new CrashedChunkSet(xcOrigin, zcOrigin, xOrigin, yOrigin, zOrigin);
        ccSet.age = age;
        return ccSet;
    }
}

