/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.meteor.common.ClientProxy;
import net.meteor.common.MeteorItems;
import net.meteor.common.block.BlockMeteorsMod;
import net.meteor.common.entity.EntityAlienCreeper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMeteor
extends BlockMeteorsMod {
    private IIcon hotTex;
    protected Random rand = new Random();

    public BlockMeteor() {
        super(Material.field_151576_e);
        this.func_149675_a(true);
        this.setHarvestLevel("pickaxe", 2);
        this.setHarvestLevel("pickaxe", 1, 0);
    }

    public Item func_149650_a(int i, Random random, int j) {
        return MeteorItems.itemMeteorChips;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        if (meta == 0 && random.nextInt(4) == 0) {
            return 1 + random.nextInt(fortune + 1);
        }
        return random.nextInt(1 + meta + random.nextInt(fortune + 1));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int i, int j, int k, Random random) {
        if (world.func_72805_g(i, j, k) > 0) {
            if (random.nextInt(32) == 0) {
                world.func_72980_b((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), "fire.fire", 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
            }
            this.renderGlowParticles(world, i, j, k, random);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderGlowParticles(World world, int i, int j, int k, Random random) {
        double d = 0.0625;
        for (int l = 0; l < 6; ++l) {
            double d1 = (float)i + random.nextFloat();
            double d2 = (float)j + random.nextFloat();
            double d3 = (float)k + random.nextFloat();
            if (l == 0 && !world.func_147439_a(i, j + 1, k).func_149662_c()) {
                d2 = (double)(j + 1) + d;
            }
            if (l == 1 && !world.func_147439_a(i, j - 1, k).func_149662_c()) {
                d2 = (double)(j + 0) - d;
            }
            if (l == 2 && !world.func_147439_a(i, j, k + 1).func_149662_c()) {
                d3 = (double)(k + 1) + d;
            }
            if (l == 3 && !world.func_147439_a(i, j, k - 1).func_149662_c()) {
                d3 = (double)(k + 0) - d;
            }
            if (l == 4 && !world.func_147439_a(i + 1, j, k).func_149662_c()) {
                d1 = (double)(i + 1) + d;
            }
            if (l == 5 && !world.func_147439_a(i - 1, j, k).func_149662_c()) {
                d1 = (double)(i + 0) - d;
            }
            if (!(d1 < (double)i || d1 > (double)(i + 1) || d2 < 0.0 || d2 > (double)(j + 1) || d3 < (double)k) && !(d3 > (double)(k + 1))) continue;
            ClientProxy.spawnParticle("meteordust", d1, d2, d3, 0.0, 0.0, 0.0, world, -1);
        }
    }

    public int func_149738_a(World world) {
        return 30;
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        AxisAlignedBB AABB = super.func_149668_a(world, i, j, k);
        return AABB.func_72331_e(0.006, 0.006, 0.006);
    }

    public boolean isBurning(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) > 0;
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        int metadata = world.func_72805_g(x, y, z);
        if (side == ForgeDirection.UP && metadata > 0) {
            return true;
        }
        return super.isFireSource(world, x, y, z, side);
    }

    public void func_149674_a(World world, int i, int j, int k, Random random) {
        int meta = world.func_72805_g(i, j, k);
        if (meta > 0) {
            if (this.isWaterAround(world, i, j, k)) {
                world.func_72921_c(i, j, k, 0, 2);
                this.triggerLavaMixEffects(world, i, j, k);
            } else {
                world.func_72921_c(i, j, k, --meta, 2);
                if (meta == 0) {
                    this.triggerLavaMixEffects(world, i, j, k);
                }
            }
        }
    }

    protected void triggerLavaMixEffects(World world, int i, int j, int k) {
        world.func_72908_a((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            world.func_72869_a("largesmoke", (double)i + Math.random(), (double)j + 1.2, (double)k + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    private boolean isWaterAround(World world, int i, int j, int k) {
        for (int sY = j + 1; sY >= j - 1; --sY) {
            for (int sX = i + 1; sX >= i - 1; --sX) {
                for (int sZ = k + 1; sZ >= k - 1; --sZ) {
                    Block block = world.func_147439_a(sX, sY, sZ);
                    if (!Block.func_149680_a((Block)block, (Block)Blocks.field_150355_j) && !Block.func_149680_a((Block)block, (Block)Blocks.field_150358_i)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int i, int j) {
        if (j == 0) {
            super.func_149691_a(i, j);
            return this.field_149761_L;
        }
        return this.hotTex;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("meteors:Meteor");
        this.hotTex = par1IconRegister.func_94245_a("meteors:Meteor_Hot");
    }

    public void func_149664_b(World world, int i, int j, int k, int l) {
        super.func_149664_b(world, i, j, k, l);
        if (!world.field_72995_K && world.field_73012_v.nextInt(100) == 95) {
            EntityAlienCreeper creeper = new EntityAlienCreeper(world);
            creeper.func_70012_b(i, j, k, 0.0f, 0.0f);
            world.func_72838_d((Entity)creeper);
            creeper.func_70656_aK();
            return;
        }
    }

    public int getLightValue(IBlockAccess iba, int i, int j, int k) {
        if (iba.func_72805_g(i, j, k) > 0) {
            return this.func_149750_m();
        }
        return 0;
    }

    public int getExpDrop(IBlockAccess world, int metadata, int fortune) {
        return MathHelper.func_76136_a((Random)this.rand, (int)2, (int)5);
    }
}

