/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.plugin.baubles;

import baubles.api.BaublesApi;
import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import net.meteor.common.MeteorsMod;
import net.meteor.common.packets.AbstractPacket;
import net.meteor.plugin.baubles.Baubles;
import net.meteor.plugin.baubles.ItemMagnetismController;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class PacketTogglePlayerMagnetism
extends AbstractPacket {
    private String playerName;

    public PacketTogglePlayerMagnetism() {
    }

    public PacketTogglePlayerMagnetism(String pName) {
        this.playerName = pName;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        try {
            this.writeStringToBuffer(this.playerName, buffer);
        }
        catch (IOException e) {
            MeteorsMod.log.info("Could not encode player name to toggle magnetism");
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        try {
            this.playerName = this.readStringFromBuffer(64, buffer);
        }
        catch (IOException e) {
            MeteorsMod.log.info("Could not decode player name to toggle magnetism");
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        IInventory inv;
        ItemStack stack;
        EntityPlayer p = player.field_70170_p.func_72924_a(this.playerName);
        if (p != null && (stack = (inv = BaublesApi.getBaubles((EntityPlayer)p)).func_70301_a(3)) != null && stack.func_77973_b() == Baubles.MagnetismController) {
            boolean val = !ItemMagnetismController.getNBTData(stack);
            ItemMagnetismController.setNBTData(stack, val);
            if (player.func_70005_c_().equals(this.playerName)) {
                Baubles.renderDisplayTicks = Minecraft.func_71410_x().field_71441_e.func_82737_E() + 100L;
                Baubles.renderDisplay = true;
                Baubles.enabledMagnetism = val;
            }
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }

    private void writeStringToBuffer(String str, ByteBuf buffer) throws IOException {
        byte[] abyte = str.getBytes(Charsets.UTF_8);
        if (abyte.length > Short.MAX_VALUE) {
            throw new IOException("String too big (was " + str.length() + " bytes encoded, max " + Short.MAX_VALUE + ")");
        }
        buffer.writeInt(abyte.length);
        buffer.writeBytes(abyte);
    }

    private String readStringFromBuffer(int maxLength, ByteBuf buffer) throws IOException {
        int j = buffer.readInt();
        if (j > maxLength * 4) {
            throw new IOException("The received encoded string buffer length is longer than maximum allowed (" + j + " > " + maxLength * 4 + ")");
        }
        if (j < 0) {
            throw new IOException("The received encoded string buffer length is less than zero! Weird string!");
        }
        String s = new String(buffer.readBytes(j).array(), Charsets.UTF_8);
        if (s.length() > maxLength) {
            throw new IOException("The received string length is longer than maximum allowed (" + j + " > " + maxLength + ")");
        }
        return s;
    }
}

