/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.meteor.common.ClientHandler;
import net.meteor.common.EnumMeteor;
import net.meteor.common.HandlerAchievement;
import net.meteor.common.IMeteorShield;
import net.meteor.common.MeteorItems;
import net.meteor.common.MeteorsMod;
import net.meteor.common.climate.HandlerMeteor;
import net.meteor.common.entity.EntityMeteor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntitySummoner
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    private static final float[][] spellRGB = new float[][]{{0.43529412f, 0.078431375f, 0.65882355f}, {0.05882353f, 0.6784314f, 0.6784314f}, {0.69411767f, 0.047058824f, 0.047058824f}, {0.39215687f, 0.37254903f, 0.34509805f}, {0.09411765f, 0.64705884f, 0.09411765f}};
    public int mID;
    public boolean isRandom;
    private EntityLiving thrower;
    private String throwerName = null;

    public EntitySummoner(World world) {
        super(world);
    }

    public EntitySummoner(World world, EntityLivingBase entityliving) {
        super(world, entityliving);
    }

    public EntitySummoner(World world, EntityLivingBase entityliving, int meteorID, boolean r) {
        this(world, entityliving);
        this.mID = meteorID;
        this.isRandom = r;
    }

    public EntitySummoner(World world, double d, double d1, double d2) {
        super(world, d, d1, d2);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            int rgbIndex = this.mID;
            if (this.isRandom) {
                rgbIndex = this.field_70170_p.field_73012_v.nextInt(5);
            }
            this.field_70170_p.func_72869_a("mobSpell", this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)spellRGB[rgbIndex][0], (double)spellRGB[rgbIndex][1], (double)spellRGB[rgbIndex][2]);
        }
    }

    protected void func_70184_a(MovingObjectPosition movingobjectposition) {
        for (int i = 0; i < 8; ++i) {
            this.field_70170_p.func_72869_a("snowballpoof", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        }
        EntityPlayer player = (EntityPlayer)this.func_85052_h();
        if (!MeteorsMod.instance.isDimensionWhitelisted(this.field_70170_p.field_73011_w.field_76574_g)) {
            if (player != null && !this.field_70170_p.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"MeteorSummoner.wrongDimension")));
                if (!player.field_71075_bZ.field_75098_d) {
                    if (this.isRandom) {
                        player.field_71071_by.func_70441_a(new ItemStack(MeteorItems.itemMeteorSummoner, 1));
                    } else {
                        player.field_71071_by.func_70441_a(new ItemStack(MeteorItems.itemMeteorSummoner, 1, this.mID + 1));
                    }
                }
            }
            this.func_70106_y();
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            IMeteorShield shield;
            boolean canHit = true;
            if (!this.field_70170_p.func_82736_K().func_82766_b("summonMeteors")) {
                canHit = false;
                player.func_145747_a(ClientHandler.createMessage(StatCollector.func_74838_a((String)"MeteorSummoner.cannotSummon"), EnumChatFormatting.RED));
                if (!player.field_71075_bZ.field_75098_d) {
                    if (this.isRandom) {
                        player.field_71071_by.func_70441_a(new ItemStack(MeteorItems.itemMeteorSummoner, 1));
                    } else {
                        player.field_71071_by.func_70441_a(new ItemStack(MeteorItems.itemMeteorSummoner, 1, this.mID + 1));
                    }
                }
            } else if (!MeteorsMod.instance.allowSummonedMeteorGrief && player != null && (shield = MeteorsMod.proxy.metHandlers.get(this.field_70170_p.field_73011_w.field_76574_g).getShieldManager().getClosestShieldInRange((int)this.field_70165_t, (int)this.field_70161_v)) != null && !player.func_70005_c_().equalsIgnoreCase(shield.getOwner())) {
                canHit = false;
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"MeteorSummoner.landProtected")));
                if (!player.field_71075_bZ.field_75098_d) {
                    if (this.isRandom) {
                        player.field_71071_by.func_70441_a(new ItemStack(MeteorItems.itemMeteorSummoner, 1));
                    } else {
                        player.field_71071_by.func_70441_a(new ItemStack(MeteorItems.itemMeteorSummoner, 1, this.mID + 1));
                    }
                }
            }
            if (canHit) {
                if (player != null) {
                    player.func_145747_a(ClientHandler.createMessage(StatCollector.func_74838_a((String)"MeteorSummoner.incomingMeteor"), EnumChatFormatting.LIGHT_PURPLE));
                    player.func_71029_a((StatBase)HandlerAchievement.summonMeteor);
                }
                EntityMeteor meteorToSpawn = new EntityMeteor(this.field_70170_p, HandlerMeteor.getMeteorSize(), this.field_70165_t, this.field_70161_v, EnumMeteor.getTypeFromID(this.mID), true);
                this.field_70170_p.func_72838_d((Entity)meteorToSpawn);
            }
        }
        this.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("metType", this.mID);
        par1NBTTagCompound.func_74757_a("isRandom", this.isRandom);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.mID = par1NBTTagCompound.func_74762_e("metType");
        this.isRandom = par1NBTTagCompound.func_74767_n("isRandom");
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.mID);
        buffer.writeBoolean(this.isRandom);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.mID = additionalData.readInt();
        this.isRandom = additionalData.readBoolean();
    }
}

