/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.climate;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.meteor.common.ClientHandler;
import net.meteor.common.EnumMeteor;
import net.meteor.common.HandlerAchievement;
import net.meteor.common.IMeteorShield;
import net.meteor.common.MeteorsMod;
import net.meteor.common.climate.ClimateUpdater;
import net.meteor.common.climate.CrashLocation;
import net.meteor.common.climate.CrashedChunkSet;
import net.meteor.common.climate.CrashedChunkSetData;
import net.meteor.common.climate.GhostMeteor;
import net.meteor.common.climate.GhostMeteorData;
import net.meteor.common.climate.HandlerMeteorTick;
import net.meteor.common.climate.MeteorForecast;
import net.meteor.common.climate.ShieldManager;
import net.meteor.common.entity.EntityMeteor;
import net.meteor.common.packets.PacketGhostMeteor;
import net.meteor.common.packets.PacketLastCrash;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.WorldEvent;

public class HandlerMeteor {
    private WorldServer theWorld;
    private String worldName;
    private ClimateUpdater climateUpdater;
    private GhostMeteorData gMetData;
    private CrashedChunkSetData ccSetData;
    private final MeteorForecast forecast;
    private ShieldManager shieldManager;
    private static Random random = new Random();
    public ArrayList<GhostMeteor> ghostMets = new ArrayList();
    public ArrayList<CrashedChunkSet> crashedChunks = new ArrayList();
    public static EnumMeteor defaultType;

    public HandlerMeteor(WorldEvent.Load event, HandlerMeteorTick worldTickHandler) {
        MeteorsMod.instance.setClientStartConfig();
        this.theWorld = (WorldServer)event.world;
        this.gMetData = GhostMeteorData.forWorld((World)this.theWorld, this);
        this.ccSetData = CrashedChunkSetData.forWorld((World)this.theWorld, this);
        this.worldName = this.theWorld.func_72912_H().func_76065_j();
        this.climateUpdater = new ClimateUpdater(this);
        this.forecast = new MeteorForecast(this.climateUpdater, this.ghostMets, this.ccSetData.getLoadedCrashLocation(), (World)this.theWorld);
        this.shieldManager = new ShieldManager((World)this.theWorld);
        worldTickHandler.registerUpdater(this.theWorld.field_73011_w.field_76574_g, this.climateUpdater);
    }

    public void updateMeteors() {
        if (this.theWorld == null) {
            return;
        }
        for (int i = 0; i < this.ghostMets.size(); ++i) {
            if (this.theWorld.func_72820_D() % 24000L < 12000L && MeteorsMod.instance.meteorsFallOnlyAtNight) continue;
            GhostMeteor gMeteor = this.ghostMets.get(i);
            ChunkCoordIntPair coords = this.theWorld.func_72938_d(gMeteor.x, gMeteor.z).func_76632_l();
            if (!this.canSpawnNewMeteorAt(coords)) {
                this.sendGhostMeteorRemovePacket(gMeteor);
                this.ghostMets.remove(i);
                this.forecast.updateNearestTimeForClients();
                continue;
            }
            gMeteor.update();
            if (!gMeteor.ready) continue;
            IMeteorShield shield = this.shieldManager.getClosestShieldInRange(gMeteor.x, gMeteor.z);
            if (shield != null) {
                String owner = shield.getOwner();
                EntityPlayerMP player = this.theWorld.func_73046_m().func_71203_ab().func_152612_a(owner);
                if (player != null) {
                    player.func_145747_a(ClientHandler.createMessage(StatCollector.func_74838_a((String)"MeteorShield.meteorBlocked"), EnumChatFormatting.GREEN));
                    player.func_71064_a((StatBase)HandlerAchievement.meteorBlocked, 1);
                }
                this.shieldManager.sendMeteorMaterialsToShield(shield, gMeteor);
            } else if (gMeteor.type == EnumMeteor.KITTY) {
                this.kittyAttack();
            } else {
                EntityMeteor meteor = new EntityMeteor((World)this.theWorld, gMeteor.size, gMeteor.x, gMeteor.z, gMeteor.type, false);
                this.theWorld.func_72838_d((Entity)meteor);
                this.applyMeteorCrash(gMeteor.x, 0, gMeteor.z);
                this.playCrashSound(meteor);
            }
            this.sendGhostMeteorRemovePacket(gMeteor);
            this.ghostMets.remove(i);
            this.forecast.updateNearestTimeForClients();
        }
    }

    public void kittyAttack() {
        this.theWorld.func_73046_m().func_71203_ab().func_148539_a(ClientHandler.createMessage(StatCollector.func_74838_a((String)"Meteor.kittiesIncoming"), EnumChatFormatting.DARK_RED));
        for (int i = 0; i < this.theWorld.field_73010_i.size(); ++i) {
            EntityPlayer player = (EntityPlayer)this.theWorld.field_73010_i.get(i);
            if (player == null) continue;
            for (int r = random.nextInt(64) + 50; r >= 0; --r) {
                IMeteorShield shield;
                int x = random.nextInt(64);
                int z = random.nextInt(64);
                if (random.nextBoolean()) {
                    x = -x;
                }
                if (random.nextBoolean()) {
                    z = -z;
                }
                if ((shield = this.shieldManager.getClosestShieldInRange(x = (int)((double)x + player.field_70165_t), z = (int)((double)z + player.field_70161_v))) != null) {
                    String owner = shield.getOwner();
                    EntityPlayerMP playerOwner = this.theWorld.func_73046_m().func_71203_ab().func_152612_a(owner);
                    if (playerOwner != null) {
                        playerOwner.func_145747_a(ClientHandler.createMessage(StatCollector.func_74838_a((String)"MeteorShield.meteorBlocked"), EnumChatFormatting.GREEN));
                        playerOwner.func_71064_a((StatBase)HandlerAchievement.meteorBlocked, 1);
                    }
                    this.shieldManager.sendMeteorMaterialsToShield(shield, new GhostMeteor(x, z, 1, 0, EnumMeteor.KITTY));
                    continue;
                }
                EntityMeteor fKitty = new EntityMeteor((World)this.theWorld, 1, x, z, EnumMeteor.KITTY, false);
                fKitty.spawnPauseTicks = random.nextInt(100);
                this.theWorld.func_72838_d((Entity)fKitty);
            }
            player.func_71064_a((StatBase)HandlerAchievement.kittyEvent, 1);
        }
    }

    public void applyMeteorCrash(int x, int y, int z) {
        int i;
        ArrayList<CrashedChunkSet> tbr = new ArrayList<CrashedChunkSet>();
        for (i = 0; i < this.crashedChunks.size(); ++i) {
            CrashedChunkSet set = this.crashedChunks.get(i);
            ++set.age;
            if (set.age < 20) continue;
            tbr.add(set);
        }
        for (i = 0; i < tbr.size(); ++i) {
            this.crashedChunks.remove(tbr.get(i));
        }
        ChunkCoordIntPair coords = this.theWorld.func_72938_d(x, z).func_76632_l();
        this.crashedChunks.add(new CrashedChunkSet(coords.field_77276_a, coords.field_77275_b, x, y, z));
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.forecast.setLastCrashLocation(new CrashLocation(x, y, z, true, this.forecast.getLastCrashLocation()));
            MeteorsMod.packetPipeline.sendToDimension(new PacketLastCrash(this.forecast.getLastCrashLocation()), this.theWorld.field_73011_w.field_76574_g);
            if (MeteorsMod.instance.textNotifyCrash) {
                this.theWorld.func_73046_m().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"Meteor.crashed")));
            }
            AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)((double)x - 60.0), (double)0.0, (double)((double)z - 60.0), (double)((double)x + 60.0), (double)this.theWorld.func_72800_K(), (double)((double)z + 60.0));
            List players = this.theWorld.func_72872_a(EntityPlayer.class, aabb);
            for (int i2 = 0; i2 < players.size(); ++i2) {
                EntityPlayer player = (EntityPlayer)players.get(i2);
                player.func_71064_a((StatBase)HandlerAchievement.foundMeteor, 1);
            }
        }
    }

    public MeteorForecast getForecast() {
        return this.forecast;
    }

    public ShieldManager getShieldManager() {
        return this.shieldManager;
    }

    public boolean canSpawnNewMeteor() {
        return this.ghostMets.size() < 3;
    }

    public boolean canSpawnNewMeteorAt(ChunkCoordIntPair coords) {
        for (int i = 0; i < this.crashedChunks.size(); ++i) {
            if (!this.crashedChunks.get(i).containsChunk(coords)) continue;
            return false;
        }
        return true;
    }

    private double getDistance(int x1, int z1, int x2, int z2) {
        int x = x1 - x2;
        int z = z1 - z2;
        return MathHelper.func_76133_a((double)(x * x + z * z));
    }

    public void readyNewMeteor(int x, int z, int size, int tGoal, EnumMeteor type) {
        if (this.canSpawnNewMeteor()) {
            GhostMeteor gMeteor = new GhostMeteor(x, z, size, tGoal, type);
            this.ghostMets.add(gMeteor);
            this.sendGhostMeteorAddPacket(gMeteor);
            this.forecast.updateNearestTimeForClients();
            if (type == EnumMeteor.KITTY) {
                for (EntityPlayer player : this.theWorld.field_73010_i) {
                    player.func_145747_a(ClientHandler.createMessage(StatCollector.func_74838_a((String)"Meteor.kittiesDetected.one"), EnumChatFormatting.DARK_RED));
                    player.func_145747_a(ClientHandler.createMessage(StatCollector.func_74838_a((String)"Meteor.kittiesDetected.two"), EnumChatFormatting.DARK_RED));
                }
            }
        }
    }

    public static int getMeteorSize() {
        int r = random.nextInt(26);
        int maxSize = MeteorsMod.instance.MaxMeteorSize;
        int minSize = MeteorsMod.instance.MinMeteorSize;
        if (maxSize == 3 && minSize == 1) {
            if (r == 25) {
                return 3;
            }
            if (r > 15) {
                return 2;
            }
            return 1;
        }
        if (maxSize == 3 && minSize == 2) {
            if (r > 15) {
                return 3;
            }
            return 2;
        }
        if (minSize == 1 && maxSize == 2) {
            if (r > 15) {
                return 2;
            }
            return 1;
        }
        return minSize;
    }

    public static EnumMeteor getMeteorType() {
        int r = random.nextInt(63);
        MeteorsMod mod = MeteorsMod.instance;
        if (r >= 60 && mod.unknownEnabled) {
            return EnumMeteor.UNKNOWN;
        }
        if (r >= 52 && mod.kreknoriteEnabled) {
            return EnumMeteor.KREKNORITE;
        }
        if (r >= 35 && mod.frezariteEnabled) {
            return EnumMeteor.FREZARITE;
        }
        return defaultType;
    }

    public static EnumMeteor getCometType() {
        EnumMeteor type = HandlerMeteor.getMeteorType();
        if (type == EnumMeteor.UNKNOWN) {
            return EnumMeteor.getTypeFromID(random.nextInt(3));
        }
        return type;
    }

    public void sendGhostMeteorPackets(EntityPlayerMP player) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            ArrayList<GhostMeteor> mets = this.ghostMets;
            for (int i = 0; i < mets.size(); ++i) {
                GhostMeteor met = mets.get(i);
                MeteorsMod.packetPipeline.sendTo(new PacketGhostMeteor(true, met), player);
            }
        }
    }

    private void sendGhostMeteorAddPacket(GhostMeteor met) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            MeteorsMod.packetPipeline.sendToDimension(new PacketGhostMeteor(true, met), this.theWorld.field_73011_w.field_76574_g);
        }
    }

    private void sendGhostMeteorRemovePacket(GhostMeteor met) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            MeteorsMod.packetPipeline.sendToDimension(new PacketGhostMeteor(false, met), this.theWorld.field_73011_w.field_76574_g);
        }
    }

    private void playCrashSound(EntityMeteor meteor) {
        for (EntityPlayer player : this.theWorld.field_73010_i) {
            double xDiff = meteor.field_70165_t - player.field_70165_t;
            double zDiff = meteor.field_70161_v - player.field_70161_v;
            double xMod = xDiff / 128.0 * 4.0;
            double zMod = zDiff / 128.0 * 4.0;
            this.theWorld.func_72908_a(player.field_70165_t + xMod, player.field_70163_u + 1.0, player.field_70161_v + zMod, "meteors:meteor.crash", 1.0f, 1.0f);
        }
    }
}

