/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.climate;

import java.util.ArrayList;
import java.util.Iterator;
import net.meteor.common.climate.CrashLocation;
import net.meteor.common.climate.CrashedChunkSet;
import net.meteor.common.climate.HandlerMeteor;
import net.meteor.common.climate.MeteorForecast;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;

public class CrashedChunkSetData
extends WorldSavedData {
    private static final String key = "metCrashedChunks";
    private static HandlerMeteor tempHandle;
    private HandlerMeteor metHandler;
    private CrashLocation cLoc = null;

    public CrashedChunkSetData(String s) {
        super(s);
    }

    public static CrashedChunkSetData forWorld(World world, HandlerMeteor metH) {
        tempHandle = metH;
        MapStorage storage = world.perWorldStorage;
        CrashedChunkSetData result = (CrashedChunkSetData)storage.func_75742_a(CrashedChunkSetData.class, key);
        if (result == null) {
            result = new CrashedChunkSetData(key);
            storage.func_75745_a(key, (WorldSavedData)result);
        }
        result.metHandler = metH;
        tempHandle = null;
        return result;
    }

    private ArrayList<CrashedChunkSet> loadCrashedChunks(NBTTagCompound tag, HandlerMeteor mHandler) {
        ArrayList<CrashedChunkSet> cList = new ArrayList<CrashedChunkSet>();
        for (int i = 1; i <= 20; ++i) {
            CrashedChunkSet ccSet;
            if (!tag.func_74764_b("CCSet" + i) || (ccSet = CrashedChunkSet.fromNBTString(tag.func_74779_i("CCSet" + i))) == null) continue;
            cList.add(ccSet);
        }
        this.cLoc = CrashLocation.fromNBT(tag);
        return cList;
    }

    private void saveCrashedChunks(NBTTagCompound tag) {
        int i;
        Iterator<CrashedChunkSet> iter = this.metHandler.crashedChunks.iterator();
        for (i = 1; iter.hasNext() && i <= 20; ++i) {
            CrashedChunkSet ccSet = iter.next();
            tag.func_74778_a("CCSet" + i, ccSet.toString());
        }
        while (i < 21) {
            if (tag.func_74764_b("CCSet" + i)) {
                tag.func_82580_o("CCSet" + i);
            }
            ++i;
        }
        MeteorForecast forecast = this.metHandler.getForecast();
        if (forecast.getLastCrashLocation() != null) {
            forecast.getLastCrashLocation().toNBT(tag);
        }
    }

    public void func_76184_a(NBTTagCompound tag) {
        if (this.metHandler != null) {
            this.metHandler.crashedChunks = this.loadCrashedChunks(tag, this.metHandler);
        } else {
            CrashedChunkSetData.tempHandle.crashedChunks = this.loadCrashedChunks(tag, tempHandle);
        }
    }

    public void func_76187_b(NBTTagCompound tag) {
        this.saveCrashedChunks(tag);
    }

    public boolean func_76188_b() {
        return true;
    }

    public CrashLocation getLoadedCrashLocation() {
        return this.cLoc;
    }
}

