/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.meteor.common.ClientProxy;
import net.meteor.common.IMeteorShield;
import net.meteor.common.MeteorBlocks;
import net.meteor.common.MeteorsMod;
import net.meteor.common.climate.HandlerMeteor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class BlockMeteorShieldTorch
extends BlockTorch {
    private boolean torchActive;

    public BlockMeteorShieldTorch(boolean active) {
        this.torchActive = active;
        this.func_149675_a(true);
    }

    public int func_149738_a(World world) {
        return 2;
    }

    public void func_149674_a(World world, int i, int j, int k, Random random) {
        this.checkArea(world, i, j, k);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int i, int j, int k, Random random) {
        if (!this.torchActive) {
            return;
        }
        int l = world.func_72805_g(i, j, k);
        double d = (double)((float)i + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double d1 = (double)((float)j + 0.7f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double d2 = (double)((float)k + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double d3 = 0.219999998807907;
        double d4 = 0.2700000107288361;
        if (l == 1) {
            ClientProxy.spawnParticle("meteordust", d - d4, d1 + d3, d2, 0.0, 0.0, 0.0, world, -1);
        } else if (l == 2) {
            ClientProxy.spawnParticle("meteordust", d + d4, d1 + d3, d2, 0.0, 0.0, 0.0, world, -1);
        } else if (l == 3) {
            ClientProxy.spawnParticle("meteordust", d, d1 + d3, d2 - d4, 0.0, 0.0, 0.0, world, -1);
        } else if (l == 4) {
            ClientProxy.spawnParticle("meteordust", d, d1 + d3, d2 + d4, 0.0, 0.0, 0.0, world, -1);
        } else {
            ClientProxy.spawnParticle("meteordust", d, d1, d2, 0.0, 0.0, 0.0, world, -1);
        }
    }

    public Item func_149650_a(int i, Random random, int j) {
        return Item.func_150898_a((Block)MeteorBlocks.torchMeteorShieldActive);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_149726_b(World world, int i, int j, int k) {
        if (world.func_72805_g(i, j, k) == 0) {
            super.func_149726_b(world, i, j, k);
        }
        this.checkArea(world, i, j, k);
    }

    private void checkArea(World world, int i, int j, int k) {
        boolean isSafeChunk;
        boolean bl = isSafeChunk = MeteorsMod.proxy.metHandlers.get(world.field_73011_w.field_76574_g).getShieldManager().getClosestShieldInRange(i, k) != null;
        if (this.torchActive) {
            if (!isSafeChunk) {
                world.func_147465_d(i, j, k, MeteorBlocks.torchMeteorShieldIdle, world.func_72805_g(i, j, k), 3);
            }
        } else if (isSafeChunk) {
            world.func_147465_d(i, j, k, MeteorBlocks.torchMeteorShieldActive, world.func_72805_g(i, j, k), 3);
        }
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (!world.field_72995_K) {
            this.checkArea(world, i, j, k);
            HandlerMeteor meteorHandler = MeteorsMod.proxy.metHandlers.get(world.field_73011_w.field_76574_g);
            List<IMeteorShield> shields = meteorHandler.getShieldManager().getShieldsInRange(i, k);
            if (!shields.isEmpty()) {
                int l;
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"ProtectionTorch.landOwnership")));
                ArrayList<String> owners = new ArrayList<String>();
                for (l = 0; l < shields.size(); ++l) {
                    IMeteorShield oPair = shields.get(l);
                    if (owners.contains(oPair.getOwner())) continue;
                    owners.add(oPair.getOwner());
                }
                for (l = 0; l < owners.size(); ++l) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("    - " + (String)owners.get(l)));
                }
            }
        }
        return true;
    }

    public Block func_149658_d(String s) {
        return super.func_149658_d("meteors:" + s);
    }
}

