/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class SBAPI {
    public static int TopOfDoor = 8;
    public static int DoorFaceWest = 0;
    public static int DoorFaceSouth = 1;
    public static int DoorFaceEast = 2;
    public static int DoorFaceNorth = 3;
    public static int SlabStone = 0;
    public static int SlabSand = 1;
    public static int SlabWood = 2;
    public static int SlabCobble = 3;
    public static int SlabBrick = 4;
    public static int SlabSmoothStoneBrick = 5;
    public static int HeadOfBed = 8;
    public static int PlaceBedSouthward = 0;
    public static int PlaceBedWestward = 1;
    public static int PlaceBedNorthward = 2;
    public static int PlaceBedEastward = 3;
    public static int StairsPointWestward = 0;
    public static int StairsPointEastward = 1;
    public static int StairsPointNorthward = 2;
    public static int StairsPointSouthward = 3;
    public static int WoodRegular = 0;
    public static int WoodDark = 1;
    public static int WoodBirch = 2;
    public static int WoolWhite = 0;
    public static int WoolOrange = 1;
    public static int WoolMagenta = 2;
    public static int WoolLightBlue = 3;
    public static int WoolYellow = 4;
    public static int WoolLime = 5;
    public static int WoolPink = 6;
    public static int WoolGray = 7;
    public static int WoolLightGray = 8;
    public static int WoolCyan = 9;
    public static int WoolPurple = 10;
    public static int WoolBlue = 11;
    public static int WoolBrown = 12;
    public static int WoolGreen = 13;
    public static int WoolRed = 14;
    public static int WoolBlack = 15;

    public static void placeBlock(World world, int x, int y, int z, Block block, int mData) {
        if (block == Blocks.field_150466_ao) {
            if (mData >= TopOfDoor) {
                if (world.func_147439_a(x, y - 1, z) != block) {
                    world.func_147465_d(x, y - 1, z, block, mData - TopOfDoor, 3);
                }
            } else if (mData < TopOfDoor && world.func_147439_a(x, y + 1, z) != block) {
                world.func_147465_d(x, y + 1, z, block, mData + TopOfDoor, 3);
            }
        } else if (block == Blocks.field_150454_av) {
            if (mData >= TopOfDoor) {
                if (world.func_147439_a(x, y - 1, z) != block) {
                    world.func_147465_d(x, y - 1, z, block, mData - TopOfDoor, 3);
                }
            } else if (mData < TopOfDoor && world.func_147439_a(x, y + 1, z) != block) {
                world.func_147465_d(x, y + 1, z, block, mData + TopOfDoor, 3);
            }
        } else if (block == Blocks.field_150324_C) {
            if (mData >= HeadOfBed) {
                boolean bedTowardNorthSouth = SBAPI.getBedPlacementDirectionNorthOrSouth(mData - 8);
                if (bedTowardNorthSouth) {
                    if (mData - 8 == PlaceBedNorthward) {
                        world.func_147465_d(x, y, z - 1, Blocks.field_150324_C, PlaceBedNorthward, 3);
                    } else if (mData - 8 == PlaceBedSouthward) {
                        world.func_147465_d(x, y, z + 1, Blocks.field_150324_C, PlaceBedSouthward, 3);
                    }
                } else if (mData - 8 == PlaceBedEastward) {
                    world.func_147465_d(x + 1, y, z, Blocks.field_150324_C, PlaceBedEastward, 3);
                } else if (mData - 8 == PlaceBedWestward) {
                    world.func_147465_d(x - 1, y, z, Blocks.field_150324_C, PlaceBedWestward, 3);
                }
            } else if (mData < HeadOfBed) {
                boolean bedTowardNorthSouth = SBAPI.getBedPlacementDirectionNorthOrSouth(mData);
                if (bedTowardNorthSouth) {
                    if (mData == PlaceBedNorthward) {
                        world.func_147465_d(x, y, z - 1, Blocks.field_150324_C, PlaceBedNorthward + HeadOfBed, 3);
                    } else if (mData == PlaceBedSouthward) {
                        world.func_147465_d(x, y, z + 1, Blocks.field_150324_C, PlaceBedSouthward + HeadOfBed, 3);
                    }
                } else if (mData == PlaceBedEastward) {
                    world.func_147465_d(x + 1, y, z, Blocks.field_150324_C, PlaceBedEastward + HeadOfBed, 3);
                } else if (mData == PlaceBedWestward) {
                    world.func_147465_d(x - 1, y, z, Blocks.field_150324_C, PlaceBedWestward + HeadOfBed, 3);
                }
            }
        }
        world.func_147465_d(x, y, z, block, mData, 3);
    }

    public static void placeBlock(World world, int x, int y, int z, Block block) {
        SBAPI.placeBlock(world, x, y, z, block, 0);
    }

    private static boolean getBedPlacementDirectionNorthOrSouth(int mData) {
        switch (mData) {
            case 0: 
            case 2: {
                return true;
            }
            case 1: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    public static void generateFloor(World world, int y, int x1, int z1, int x2, int z2, Block block, int mData) {
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (x1 > x2 || z1 > z2) break block8;
                        for (int startX = x1; startX <= x2; ++startX) {
                            for (int startZ = z1; startZ <= z2; ++startZ) {
                                SBAPI.placeBlock(world, startX, y, startZ, block, mData);
                            }
                        }
                        break block9;
                    }
                    if (x1 > x2 || z1 < z2) break block10;
                    for (int startX = x1; startX <= x2; ++startX) {
                        for (int startZ = z1; startZ >= z2; --startZ) {
                            SBAPI.placeBlock(world, startX, y, startZ, block, mData);
                        }
                    }
                    break block9;
                }
                if (x1 < x2 || z1 > z2) break block11;
                for (int startX = x1; startX >= x2; --startX) {
                    for (int startZ = z1; startZ <= z2; ++startZ) {
                        SBAPI.placeBlock(world, startX, y, startZ, block, mData);
                    }
                }
                break block9;
            }
            if (x1 < x2 || z1 < z2) break block9;
            for (int startX = x1; startX >= x2; --startX) {
                for (int startZ = z1; startZ >= z2; --startZ) {
                    SBAPI.placeBlock(world, startX, y, startZ, block, mData);
                }
            }
        }
    }

    public static void generateFloor(World world, int y, int x1, int z1, int x2, int z2, Block block) {
        SBAPI.generateFloor(world, y, x1, z1, x2, z2, block, 0);
    }

    public static void generateHollowFloor(World world, int y, int x1, int z1, int x2, int z2, Block block, int mData) {
        block8: {
            int startZ;
            block7: {
                int startX;
                if (x1 <= x2) {
                    for (startX = x1; startX <= x2; ++startX) {
                        SBAPI.placeBlock(world, startX, y, z1, block, mData);
                        SBAPI.placeBlock(world, startX, y, z2, block, mData);
                    }
                } else if (x1 >= x2) {
                    for (startX = x1; startX >= x2; --startX) {
                        SBAPI.placeBlock(world, startX, y, z1, block, mData);
                        SBAPI.placeBlock(world, startX, y, z2, block, mData);
                    }
                }
                if (z1 > z2) break block7;
                for (startZ = z1; startZ <= z2; ++startZ) {
                    SBAPI.placeBlock(world, x1, y, startZ, block, mData);
                    SBAPI.placeBlock(world, x2, y, startZ, block, mData);
                }
                break block8;
            }
            if (z1 < z2) break block8;
            for (startZ = z1; startZ >= z2; --startZ) {
                SBAPI.placeBlock(world, x1, y, startZ, block, mData);
                SBAPI.placeBlock(world, x2, y, startZ, block, mData);
            }
        }
    }

    public static void generateHollowFloor(World world, int y, int x1, int z1, int x2, int z2, Block block) {
        SBAPI.generateHollowFloor(world, y, x1, z1, x2, z2, block, 0);
    }

    public static void generateEastWestWall(World world, int x, int y1, int z1, int y2, int z2, Block block, int mData) {
        SBAPI.generateXWall(world, x, y1, z1, y2, z2, block, mData);
    }

    public static void generateEastWestWall(World world, int x, int y1, int z1, int y2, int z2, Block block) {
        SBAPI.generateXWall(world, x, y1, z1, y2, z2, block, 0);
    }

    public static void generateHollowEastWestWall(World world, int x, int y1, int z1, int y2, int z2, Block block, int mData) {
        SBAPI.generateHollowXWall(world, x, y1, z1, y2, z2, block, mData);
    }

    public static void generateHollowEastWestWall(World world, int x, int y1, int z1, int y2, int z2, Block block) {
        SBAPI.generateHollowXWall(world, x, y1, z1, y2, z2, block, 0);
    }

    public static void generateNorthSouthWall(World world, int z, int x1, int y1, int x2, int y2, Block block, int mData) {
        SBAPI.generateZWall(world, z, x1, y1, x2, y2, block, mData);
    }

    public static void generateNorthSouthWall(World world, int z, int x1, int y1, int x2, int y2, Block block) {
        SBAPI.generateZWall(world, z, x1, y1, x2, y2, block, 0);
    }

    public static void generateHollowNorthSouthWall(World world, int z, int x1, int y1, int x2, int y2, Block block, int mData) {
        SBAPI.generateHollowZWall(world, z, x1, y1, x2, y2, block, mData);
    }

    public static void generateHollowNorthSouthWall(World world, int z, int x1, int y1, int x2, int y2, Block block) {
        SBAPI.generateHollowZWall(world, z, x1, y1, x2, y2, block, 0);
    }

    public static void generateXWall(World world, int x, int y1, int z1, int y2, int z2, Block block, int mData) {
        block9: {
            block8: {
                if (y1 < y2) break block8;
                for (int startY = y1; startY >= y2; --startY) {
                    int startZ;
                    if (z1 >= z2) {
                        for (startZ = z1; startZ >= z2; --startZ) {
                            SBAPI.placeBlock(world, x, startY, startZ, block, mData);
                        }
                        continue;
                    }
                    if (z1 > z2) continue;
                    for (startZ = z1; startZ <= z2; ++startZ) {
                        SBAPI.placeBlock(world, x, startY, startZ, block, mData);
                    }
                }
                break block9;
            }
            if (y1 > y2) break block9;
            for (int startY = y1; startY <= y2; ++startY) {
                int startZ;
                if (z1 >= z2) {
                    for (startZ = z1; startZ >= z2; --startZ) {
                        SBAPI.placeBlock(world, x, startY, startZ, block, mData);
                    }
                    continue;
                }
                if (z1 > z2) continue;
                for (startZ = z1; startZ <= z2; ++startZ) {
                    SBAPI.placeBlock(world, x, startY, startZ, block, mData);
                }
            }
        }
    }

    public static void generateXWall(World world, int x, int y1, int z1, int y2, int z2, Block block) {
        SBAPI.generateXWall(world, x, y1, z1, y2, z2, block, 0);
    }

    public static void generateZWall(World world, int z, int x1, int y1, int x2, int y2, Block block, int mData) {
        block9: {
            block8: {
                if (y1 < y2) break block8;
                for (int startY = y1; startY >= y2; --startY) {
                    int startX;
                    if (x1 >= x2) {
                        for (startX = x1; startX >= x2; --startX) {
                            SBAPI.placeBlock(world, startX, startY, z, block, mData);
                        }
                        continue;
                    }
                    if (x1 > x2) continue;
                    for (startX = x1; startX <= x2; ++startX) {
                        SBAPI.placeBlock(world, startX, startY, z, block, mData);
                    }
                }
                break block9;
            }
            if (y1 > y2) break block9;
            for (int startY = y1; startY <= y2; ++startY) {
                int startX;
                if (x1 >= x2) {
                    for (startX = x1; startX >= x2; --startX) {
                        SBAPI.placeBlock(world, startX, startY, z, block, mData);
                    }
                    continue;
                }
                if (x1 > x2) continue;
                for (startX = x1; startX <= x2; ++startX) {
                    SBAPI.placeBlock(world, startX, startY, z, block, mData);
                }
            }
        }
    }

    public static void generateZWall(World world, int z, int x1, int y1, int x2, int y2, Block block) {
        SBAPI.generateZWall(world, z, x1, y1, x2, y2, block, 0);
    }

    public static void generateHollowXWall(World world, int x, int y1, int z1, int y2, int z2, Block block, int mData) {
        block8: {
            int startZ;
            block7: {
                int startY;
                if (y1 >= y2) {
                    for (startY = y1; startY >= y2; --startY) {
                        SBAPI.placeBlock(world, x, startY, z1, block, mData);
                        SBAPI.placeBlock(world, x, startY, z2, block, mData);
                    }
                } else if (y1 <= y2) {
                    for (startY = y1; startY <= y2; ++startY) {
                        SBAPI.placeBlock(world, x, startY, z1, block, mData);
                        SBAPI.placeBlock(world, x, startY, z2, block, mData);
                    }
                }
                if (z1 < z2) break block7;
                for (startZ = z1; startZ >= z2; --startZ) {
                    SBAPI.placeBlock(world, x, y1, startZ, block, mData);
                    SBAPI.placeBlock(world, x, y2, startZ, block, mData);
                }
                break block8;
            }
            if (z1 > z2) break block8;
            for (startZ = z1; startZ <= z2; ++startZ) {
                SBAPI.placeBlock(world, x, y1, startZ, block, mData);
                SBAPI.placeBlock(world, x, y2, startZ, block, mData);
            }
        }
    }

    public static void generateHollowXWall(World world, int x, int y1, int z1, int y2, int z2, Block block) {
        SBAPI.generateHollowXWall(world, x, y1, z1, y2, z2, block, 0);
    }

    public static void generateHollowZWall(World world, int z, int x1, int y1, int x2, int y2, Block block, int mData) {
        block8: {
            int startX;
            block7: {
                int startY;
                if (y1 >= y2) {
                    for (startY = y1; startY >= y2; --startY) {
                        SBAPI.placeBlock(world, x1, startY, z, block, mData);
                        SBAPI.placeBlock(world, x2, startY, z, block, mData);
                    }
                } else if (y1 <= y2) {
                    for (startY = y1; startY <= y2; ++startY) {
                        SBAPI.placeBlock(world, x1, startY, z, block, mData);
                        SBAPI.placeBlock(world, x2, startY, z, block, mData);
                    }
                }
                if (x1 < x2) break block7;
                for (startX = x1; startX >= x2; --startX) {
                    SBAPI.placeBlock(world, startX, y1, z, block, mData);
                    SBAPI.placeBlock(world, startX, y2, z, block, mData);
                }
                break block8;
            }
            if (x1 > x2) break block8;
            for (startX = x1; startX <= x2; ++startX) {
                SBAPI.placeBlock(world, startX, y1, z, block, mData);
                SBAPI.placeBlock(world, startX, y2, z, block, mData);
            }
        }
    }

    public static void generateHollowZWall(World world, int z, int x1, int y1, int x2, int y2, Block block) {
        SBAPI.generateHollowZWall(world, z, x1, y1, x2, y2, block, 0);
    }

    public static boolean generateWall(World world, int x1, int y1, int z1, int x2, int y2, int z2, Block block, int mData) {
        return SBAPI.generateWall(world, x1, y1, z1, x2, y2, z2, block, mData, false);
    }

    public static boolean generateWall(World world, int x1, int y1, int z1, int x2, int y2, int z2, Block block) {
        return SBAPI.generateWall(world, x1, y1, z1, x2, y2, z2, block, 0);
    }

    public static boolean generateWall(World world, int x1, int y1, int z1, int x2, int y2, int z2, Block block, int mData, boolean hollow) {
        if (x1 == x2) {
            if (hollow) {
                SBAPI.generateHollowXWall(world, x1, y1, z1, y2, z2, block, mData);
            } else {
                SBAPI.generateXWall(world, x1, y1, z1, y2, z2, block, mData);
            }
            return true;
        }
        if (z1 == z2) {
            if (hollow) {
                SBAPI.generateHollowZWall(world, z1, x1, y1, x2, y2, block, mData);
            } else {
                SBAPI.generateZWall(world, z1, x1, y1, x2, y2, block, mData);
            }
            return true;
        }
        return false;
    }

    public static void generateCuboid(World world, int x1, int y1, int z1, int x2, int y2, int z2, Block block, int mData) {
        SBAPI.generateCuboid(world, x1, y1, z1, x2, y2, z2, block, mData, false);
    }

    public static void generateCuboid(World world, int x1, int y1, int z1, int x2, int y2, int z2, Block block) {
        SBAPI.generateCuboid(world, x1, y1, z1, x2, y2, z2, block, 0);
    }

    public static void generateCuboid(World world, int x1, int y1, int z1, int x2, int y2, int z2, Block block, int mData, boolean hollow) {
        block13: {
            block12: {
                if (y1 != y2) break block12;
                if (hollow) {
                    SBAPI.generateHollowFloor(world, y1, x1, z1, x2, z2, block, mData);
                } else {
                    SBAPI.generateFloor(world, y1, x1, z1, x2, z2, block, mData);
                }
                break block13;
            }
            if (SBAPI.generateWall(world, x1, y1, z1, x2, y2, z2, block, mData, hollow)) break block13;
            if (hollow) {
                SBAPI.generateFloor(world, y1, x1, z1, x2, z2, block, mData);
                SBAPI.generateFloor(world, y2, x1, z1, x2, z2, block, mData);
                if (y1 >= y2) {
                    for (int startY = y1 - 1; startY >= y2 + 1; --startY) {
                        SBAPI.generateHollowFloor(world, startY, x1, z1, x2, z2, block, mData);
                    }
                } else {
                    for (int startY = y1 + 1; startY <= y2 - 1; ++startY) {
                        SBAPI.generateHollowFloor(world, startY, x1, z1, x2, z2, block, mData);
                    }
                }
            } else if (y1 >= y2) {
                for (int startY = y1; startY >= y2; --startY) {
                    SBAPI.generateFloor(world, startY, x1, z1, x2, z2, block, mData);
                }
            } else {
                for (int startY = y1; startY <= y2; ++startY) {
                    SBAPI.generateFloor(world, startY, x1, z1, x2, z2, block, mData);
                }
            }
        }
    }
}

