/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ModConfig {
    private Configuration config;
    private boolean isLoaded = false;
    public static final ModConfig instance = new ModConfig();

    private ModConfig() {
    }

    public void load(File suggestedFile) {
        this.config = new Configuration(suggestedFile);
        this.load();
    }

    private void load() {
        if (!this.isLoaded || this.config.hasChanged()) {
            this.config.load();
            this.isLoaded = true;
        }
    }

    public int get(String category, String key, int defVal, String comment) {
        this.load();
        int i = this.config.get(category, key, defVal, comment).getInt();
        this.config.save();
        return i;
    }

    public int get(String key, int defVal, String comment) {
        return this.get("general", key, defVal, comment);
    }

    public int[] get(String category, String key, int[] defVal, String comment) {
        this.load();
        int[] i = this.config.get(category, key, defVal, comment).getIntList();
        this.config.save();
        return i;
    }

    public int[] get(String key, int[] defVal, String comment) {
        return this.get("general", key, defVal, comment);
    }

    public boolean get(String category, String key, boolean defVal, String comment) {
        this.load();
        boolean b = this.config.get(category, key, defVal, comment).getBoolean(defVal);
        this.config.save();
        return b;
    }

    public boolean get(String key, boolean defVal, String comment) {
        return this.get("general", key, defVal, comment);
    }

    public double get(String category, String key, double defVal, String comment) {
        this.load();
        double d = this.config.get(category, key, defVal, comment).getDouble(defVal);
        this.config.save();
        return d;
    }

    public double get(String key, double defVal, String comment) {
        return this.get("general", key, defVal, comment);
    }
}

