/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.meteor.common.MeteorsMod;
import net.meteor.common.climate.CrashLocation;
import net.meteor.common.climate.HandlerMeteor;
import net.meteor.common.packets.PacketBlockedMeteor;
import net.meteor.common.packets.PacketGhostMeteor;
import net.meteor.common.packets.PacketLastCrash;
import net.meteor.common.packets.PacketPipeline;
import net.meteor.common.packets.PacketSettings;
import net.meteor.common.packets.PacketSoonestMeteor;
import net.meteor.plugin.baubles.Baubles;
import net.meteor.plugin.baubles.PacketToggleMagnetism;
import net.meteor.plugin.baubles.PacketTogglePlayerMagnetism;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class ClientHandler {
    public static CrashLocation lastCrashLocation = null;
    public static ChunkCoordinates nearestTimeLocation = null;
    public static ArrayList<ChunkCoordinates> ghostMetLocs = new ArrayList();
    private PacketPipeline packetPipeline;

    public ClientHandler(PacketPipeline pipeline) {
        this.packetPipeline = pipeline;
    }

    public void registerPackets() {
        this.packetPipeline.registerPacket(PacketGhostMeteor.class);
        this.packetPipeline.registerPacket(PacketLastCrash.class);
        this.packetPipeline.registerPacket(PacketSettings.class);
        this.packetPipeline.registerPacket(PacketSoonestMeteor.class);
        this.packetPipeline.registerPacket(PacketBlockedMeteor.class);
        if (Baubles.isBaublesLoaded()) {
            this.packetPipeline.registerPacket(PacketToggleMagnetism.class);
            this.packetPipeline.registerPacket(PacketTogglePlayerMagnetism.class);
        }
    }

    public static ChunkCoordinates getClosestIncomingMeteor(double pX, double pZ) {
        ChunkCoordinates coords = null;
        double y = 50.0;
        for (int i = 0; i < ghostMetLocs.size(); ++i) {
            if (coords != null) {
                double var2;
                ChunkCoordinates loc = ghostMetLocs.get(i);
                double var1 = ClientHandler.getDistance(pX, y, pZ, loc.field_71574_a, y, loc.field_71573_c);
                if (!(var1 < (var2 = ClientHandler.getDistance(pX, y, pZ, coords.field_71574_a, y, coords.field_71573_c)))) continue;
                coords = loc;
                continue;
            }
            coords = ghostMetLocs.get(i);
        }
        return coords;
    }

    private static double getDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double var7 = x1 - x2;
        double var9 = y1 - y2;
        double var11 = z1 - z2;
        return MathHelper.func_76133_a((double)(var7 * var7 + var9 * var9 + var11 * var11));
    }

    public static IChatComponent createMessage(String s, EnumChatFormatting ecf) {
        return new ChatComponentText(s).func_150255_a(new ChatStyle().func_150238_a(ecf));
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        this.packetPipeline.sendTo(new PacketSettings(), player);
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinWorldEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && event.entity instanceof EntityPlayer) {
            EntityPlayerMP player = (EntityPlayerMP)event.entity;
            HandlerMeteor metHandler = MeteorsMod.proxy.metHandlers.get(event.world.field_73011_w.field_76574_g);
            this.packetPipeline.sendTo(new PacketGhostMeteor(), player);
            metHandler.sendGhostMeteorPackets(player);
            if (metHandler.getForecast() == null) {
                MeteorsMod.log.info("FORECAST WAS NULL");
            }
            this.packetPipeline.sendTo(new PacketLastCrash(metHandler.getForecast().getLastCrashLocation()), player);
            this.packetPipeline.sendTo(new PacketSoonestMeteor(metHandler.getForecast().getNearestTimeMeteor()), player);
        }
    }
}

