/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.tree.gui;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.antlr.v4.runtime.tree.gui.SystemFontMetrics;

public class PostScriptDocument {
    private static Map<String, String> POSTSCRIPT_FONT_NAMES = new HashMap<String, String>();
    private int boundingBoxWidth;
    private int boundingBoxHeight;
    private SystemFontMetrics fontMetrics;
    private String fontName;
    private int fontSize = 12;
    private String boundingBox;
    private StringBuilder ps = new StringBuilder();
    private boolean closed = false;

    public PostScriptDocument() {
        this("Courier New", 12);
    }

    public PostScriptDocument(String fontName, int fontSize) {
        this.header();
        int n = fontSize;
        String string = fontName;
        PostScriptDocument postScriptDocument = this;
        this.fontMetrics = new SystemFontMetrics(string);
        postScriptDocument.fontName = postScriptDocument.fontMetrics.getFont().getPSName();
        postScriptDocument.fontSize = n;
        String string2 = POSTSCRIPT_FONT_NAMES.get(postScriptDocument.fontName);
        if (string2 == null) {
            string2 = postScriptDocument.fontName;
        }
        postScriptDocument.ps.append(String.format(Locale.US, "/%s findfont %d scalefont setfont\n", string2, n));
    }

    public final String getPS() {
        this.close();
        return this.header() + this.ps.toString();
    }

    public final void boundingBox(int w, int h) {
        this.boundingBoxWidth = w;
        this.boundingBoxHeight = h;
        this.boundingBox = String.format(Locale.US, "%%%%BoundingBox: %d %d %d %d\n", 0, 0, this.boundingBoxWidth, this.boundingBoxHeight);
    }

    public final void close() {
        if (this.closed) {
            return;
        }
        this.ps.append("%%Trailer\n");
        this.closed = true;
    }

    private StringBuilder header() {
        StringBuilder b = new StringBuilder();
        b.append("%!PS-Adobe-3.0 EPSF-3.0\n");
        b.append(this.boundingBox).append("\n");
        b.append("0.3 setlinewidth\n");
        b.append("%% x y w h highlight\n/highlight {\n        4 dict begin\n        /h exch def\n        /w exch def\n        /y exch def\n        /x exch def\n        gsave\n        newpath\n        x y moveto\n        0 h rlineto     % up to left corner\n        w 0 rlineto     % to upper right corner\n        0 h neg rlineto % to lower right corner\n        w neg 0 rlineto % back home to lower left corner\n        closepath\n        .95 .83 .82 setrgbcolor\n        fill\n        grestore\n        end\n} def\n");
        return b;
    }

    private void move(double x, double y) {
        this.ps.append(String.format(Locale.US, "%1.3f %1.3f moveto\n", x, y));
    }

    public final void line(double x1, double y1, double x2, double y2) {
        this.move(x1, y1);
        double d = y2;
        double d2 = x2;
        this.ps.append(String.format(Locale.US, "%1.3f %1.3f lineto\n", d2, d));
    }

    public final void highlight(double x, double y, double width, double height) {
        this.ps.append(String.format(Locale.US, "%1.3f %1.3f %1.3f %1.3f highlight\n", x, y, width, height));
    }

    public final void text(String s, double x, double y) {
        StringBuilder buf = new StringBuilder();
        block3: for (char c : s.toCharArray()) {
            switch (c) {
                case '(': 
                case ')': 
                case '\\': {
                    buf.append('\\');
                    buf.append(c);
                    continue block3;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        s = buf.toString();
        this.move(x, y);
        this.ps.append(String.format(Locale.US, "(%s) show\n", s));
        this.ps.append("stroke\n");
    }

    public final double getWidth(String s) {
        return this.fontMetrics.getWidth(s, this.fontSize);
    }

    public final double getLineHeight() {
        return this.fontMetrics.getLineHeight(this.fontSize);
    }

    static {
        POSTSCRIPT_FONT_NAMES.put("SansSerif.plain", "ArialMT");
        POSTSCRIPT_FONT_NAMES.put("SansSerif.bold", "Arial-BoldMT");
        POSTSCRIPT_FONT_NAMES.put("SansSerif.italic", "Arial-ItalicMT");
        POSTSCRIPT_FONT_NAMES.put("SansSerif.bolditalic", "Arial-BoldItalicMT");
        POSTSCRIPT_FONT_NAMES.put("Serif.plain", "TimesNewRomanPSMT");
        POSTSCRIPT_FONT_NAMES.put("Serif.bold", "TimesNewRomanPS-BoldMT");
        POSTSCRIPT_FONT_NAMES.put("Serif.italic", "TimesNewRomanPS-ItalicMT");
        POSTSCRIPT_FONT_NAMES.put("Serif.bolditalic", "TimesNewRomanPS-BoldItalicMT");
        POSTSCRIPT_FONT_NAMES.put("Monospaced.plain", "CourierNewPSMT");
        POSTSCRIPT_FONT_NAMES.put("Monospaced.bold", "CourierNewPS-BoldMT");
        POSTSCRIPT_FONT_NAMES.put("Monospaced.italic", "CourierNewPS-ItalicMT");
        POSTSCRIPT_FONT_NAMES.put("Monospaced.bolditalic", "CourierNewPS-BoldItalicMT");
    }
}

