/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.value.userdata;

import com.google.common.base.Strings;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MtsNativeFunction;
import org.apache.commons.lang3.StringUtils;

final class NativeHelpers {
    public static List<Method> getAnnotatedMethods(Class<?> clazz) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!NativeHelpers.checkMethodSignature(method)) continue;
            arrayList.add(method);
        }
        return arrayList;
    }

    private static boolean checkMethodSignature(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (!method.isAnnotationPresent(MtsNativeFunction.class)) {
            return false;
        }
        for (Class<?> clazz : method.getParameterTypes()) {
            if (MtsValue.class.isAssignableFrom(clazz)) continue;
            return false;
        }
        Class<?> clazz = method.getReturnType();
        Class<?> clazz2 = clazz;
        return MtsValue.class.isAssignableFrom(clazz2) || clazz == Void.TYPE;
    }

    public static String getMethodName(Method method) {
        MtsNativeFunction mtsNativeFunction = method.getAnnotation(MtsNativeFunction.class);
        if (mtsNativeFunction == null || Strings.isNullOrEmpty((String)mtsNativeFunction.name())) {
            return StringUtils.capitalize((String)method.getName());
        }
        return mtsNativeFunction.name();
    }
}

