/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.value;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import net.mobtalker.mobtalkerscript.v2.MtsFunctionPrototype;
import net.mobtalker.mobtalkerscript.v2.ScriptRuntimeException;
import net.mobtalker.mobtalkerscript.v2.compiler.SourcePosition;
import net.mobtalker.mobtalkerscript.v2.instruction.FrameValue;
import net.mobtalker.mobtalkerscript.v2.instruction.MtsFrame;
import net.mobtalker.mobtalkerscript.v2.value.MtsFunction;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.MtsVarArgs;

public final class MtsClosure
extends MtsFunction {
    private final MtsFunctionPrototype _prototype;
    private final List<FrameValue> _externals;

    public MtsClosure(MtsFunctionPrototype mtsFunctionPrototype, MtsValue mtsValue) {
        this(mtsFunctionPrototype, Collections.singletonList(new FrameValue(mtsValue)));
    }

    public MtsClosure(MtsFunctionPrototype mtsFunctionPrototype, List<FrameValue> list) {
        Preconditions.checkNotNull((Object)mtsFunctionPrototype);
        Preconditions.checkNotNull(list);
        this._prototype = mtsFunctionPrototype;
        this._externals = list;
    }

    public final MtsFunctionPrototype getPrototype() {
        return this._prototype;
    }

    @Override
    public final MtsValue call(MtsVarArgs mtsVarArgs) {
        MtsFrame mtsFrame = new MtsFrame(this, mtsVarArgs, this._externals);
        try {
            return mtsFrame.run();
        }
        catch (ScriptRuntimeException scriptRuntimeException) {
            String string = this._prototype.getSource();
            SourcePosition sourcePosition = this._prototype.getSourcePosition(mtsFrame.getInstructionPointer());
            String string2 = this._prototype.getName();
            scriptRuntimeException.addStackTraceElement(string, sourcePosition, string2);
            throw scriptRuntimeException;
        }
    }

    @Override
    public final boolean isClosure() {
        return true;
    }

    @Override
    public final MtsClosure asClosure() {
        return this;
    }

    public final int hashCode() {
        return this._prototype.hashCode();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MtsClosure)) {
            return false;
        }
        return ((MtsClosure)object).asClosure().getPrototype().equals(this._prototype);
    }
}

