/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import net.mobtalker.mobtalkerscript.v2.ExternalDescription;
import net.mobtalker.mobtalkerscript.v2.LocalDescription;
import net.mobtalker.mobtalkerscript.v2.compiler.SourcePosition;
import net.mobtalker.mobtalkerscript.v2.instruction.MtsInstruction;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;

public class MtsFunctionPrototype {
    private final List<MtsInstruction> _instructions;
    private final int _maxStackSize;
    private final List<MtsValue> _constants;
    private final List<ExternalDescription> _externals;
    private final List<LocalDescription> _locals;
    private final List<MtsFunctionPrototype> _nestedPrototypes;
    private final String _name;
    private final List<SourcePosition> _lineNumbers;
    private final String _sourceName;
    private final int _sourceLineStart;
    private final int _sourceLineEnd;

    public MtsFunctionPrototype(List<MtsInstruction> list, int n, List<MtsValue> list2, List<ExternalDescription> list3, List<LocalDescription> list4, String string, List<SourcePosition> list5, String string2, int n2, int n3) {
        Preconditions.checkNotNull(list);
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)("Stack size cannot be negative: " + n));
        Preconditions.checkArgument((n <= 254 ? 1 : 0) != 0, (Object)("Stack size exceeds maximum " + n));
        this._instructions = list;
        this._maxStackSize = n;
        this._constants = list2;
        this._externals = list3;
        this._locals = list4;
        this._nestedPrototypes = Lists.newArrayList();
        this._name = string;
        this._lineNumbers = list5;
        this._sourceName = string2;
        this._sourceLineStart = n2;
        this._sourceLineEnd = n3;
    }

    public List<MtsInstruction> getInstructions() {
        return this._instructions;
    }

    public int getMaxStackSize() {
        return this._maxStackSize;
    }

    public int getConstantCount() {
        return this._constants.size();
    }

    public MtsValue getConstant(int n) {
        return this._constants.get(n);
    }

    public int getExternalCount() {
        return this._externals.size();
    }

    public ExternalDescription getExternalDescription(int n) {
        return this._externals.get(n);
    }

    public int getLocalCount() {
        return this._locals.size();
    }

    public LocalDescription getLocalDescription(int n) {
        return this._locals.get(n);
    }

    public void addNestedPrototype(MtsFunctionPrototype mtsFunctionPrototype) {
        this._nestedPrototypes.add(mtsFunctionPrototype);
    }

    public MtsFunctionPrototype getNestedPrototype(int n) {
        return this._nestedPrototypes.get(n);
    }

    public String getName() {
        return this._name;
    }

    public String getSource() {
        return this._sourceName;
    }

    public SourcePosition getSourcePosition(int n) {
        Preconditions.checkElementIndex((int)n, (int)this._lineNumbers.size());
        return this._lineNumbers.get(n);
    }

    private void printLocals(StringBuilder stringBuilder, String string, boolean bl) {
        stringBuilder.append('\n').append(string);
        stringBuilder.append("locals: ").append(this._locals.size());
        if (bl) {
            for (LocalDescription localDescription : this._locals) {
                stringBuilder.append('\n').append(string).append("    ");
                stringBuilder.append("[").append(localDescription.getIndex()).append("] ").append(localDescription.getName());
            }
        }
    }

    private void printExternals(StringBuilder stringBuilder, String string, boolean bl) {
        stringBuilder.append('\n').append(string);
        stringBuilder.append("externals: ").append(this._externals.size());
        if (bl) {
            for (ExternalDescription externalDescription : this._externals) {
                stringBuilder.append('\n').append(string).append("    ");
                stringBuilder.append("[").append(externalDescription.getIndex()).append("] ").append(externalDescription.getName());
            }
        }
    }

    private void printConstants(StringBuilder stringBuilder, String string, boolean bl) {
        stringBuilder.append('\n').append(string);
        stringBuilder.append("constants: ").append(this._constants.size());
        if (bl) {
            for (int i = 0; i < this._constants.size(); ++i) {
                MtsValue mtsValue = this._constants.get(i);
                stringBuilder.append('\n').append(string).append("    ");
                stringBuilder.append("[").append(i).append("] ").append(mtsValue);
            }
        }
    }

    private void printInstructions(StringBuilder stringBuilder, String string, boolean bl) {
        stringBuilder.append('\n').append(string);
        stringBuilder.append("instructions: ").append(this._instructions.size());
        if (bl) {
            for (int i = 0; i < this._instructions.size(); ++i) {
                MtsInstruction mtsInstruction = this._instructions.get(i);
                stringBuilder.append('\n').append(string).append("    ");
                stringBuilder.append("[").append(i).append("] ").append(mtsInstruction);
            }
        }
    }

    public String toString() {
        return this.toString("", false, false);
    }

    public String toString(boolean bl, boolean bl2) {
        return this.toString("", bl, bl2);
    }

    private String toString(String string, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("function: ").append(this._name).append('\n');
        stringBuilder.append("    source: ").append(this._sourceName).append(':').append(this._sourceLineStart).append('-').append(this._sourceLineEnd).append('\n');
        stringBuilder.append("    stacksize: ").append(this._maxStackSize);
        this.printLocals(stringBuilder, "    " + string, bl);
        this.printExternals(stringBuilder, "    " + string, bl);
        this.printConstants(stringBuilder, "    " + string, bl);
        this.printInstructions(stringBuilder, "    " + string, bl);
        if (bl2) {
            for (MtsFunctionPrototype mtsFunctionPrototype : this._nestedPrototypes) {
                stringBuilder.append("\n\n");
                stringBuilder.append(mtsFunctionPrototype.toString(string + "    ", bl, true));
            }
        }
        return stringBuilder.toString();
    }
}

