/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.util;

import java.util.NoSuchElementException;

public final class Stack<T> {
    private T[] _array;
    private int _top;

    public static <T> Stack<T> newStack() {
        return new Stack<T>();
    }

    public static <T> Stack<T> newStack(int n) {
        return new Stack<T>(n);
    }

    public Stack() {
        this(8);
    }

    public Stack(int n) {
        this._array = new Object[n];
        this._top = -1;
    }

    public final void push(T t) {
        ++this._top;
        Stack stack = this;
        if (stack._array.length <= stack._top) {
            Object[] objectArray = new Object[stack._array.length << 1];
            System.arraycopy(stack._array, 0, objectArray, 0, stack._array.length);
            stack._array = objectArray;
        }
        this._array[this._top] = t;
    }

    public final T pop() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Stack is empty");
        }
        return this._array[this._top--];
    }

    public final T peek() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Stack is empty");
        }
        return this._array[this._top];
    }

    public final void swap(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("Must swap at least 2 elements");
        }
        if (n > this.count()) {
            throw new IllegalArgumentException("Tried to swap more elements than there are on the stack");
        }
        int n2 = n / 2;
        int n3 = this._top + 1 - n;
        for (int i = 0; i < n2; ++i) {
            int n4 = n3 + i;
            int n5 = this._top - i;
            T t = this._array[n5];
            this._array[n5] = this._array[n4];
            this._array[n4] = t;
        }
    }

    public final int count() {
        return this._top + 1;
    }

    public final boolean isEmpty() {
        return this._top == -1;
    }

    public final void clear() {
        this._top = -1;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("Stack [Count=");
        stringBuilder.append(this.count()).append("; ");
        if (this.count() > 1) {
            for (int i = this._top; i > 0; --i) {
                T t = this._array[i];
                stringBuilder.append(t).append(",");
            }
        }
        if (this.count() > 0) {
            stringBuilder.append(this._array[0]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

