/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.util.mgt;

import net.mobtalker.mobtalker2.util.logging.MobTalkerLog;
import net.mobtalker.mobtalker2.util.mgt.Alignment;
import net.mobtalker.mobtalker2.util.mgt.Dimension;
import net.mobtalker.mobtalker2.util.mgt.FullscreenMode;
import net.mobtalker.mobtalker2.util.mgt.MGTexture;

public class MGFullscreenTexture
extends MGTexture {
    private static final String LOG_TAG = "MGT";
    protected FullscreenMode _mode;

    public MGFullscreenTexture(int id) {
        super(id);
        this.setAlignTo(Alignment.CENTER);
        this.setMode(FullscreenMode.FIT);
    }

    public FullscreenMode getMode() {
        return this._mode;
    }

    public void setMode(FullscreenMode mode) {
        this._mode = mode;
    }

    @Override
    public void doLayout(Dimension screenDim) {
        switch (this._mode) {
            case FIT: {
                int maxTextureSize = Math.max(this.getBounds().getWidth(), this.getBounds().getHeight());
                int minScreenSize = Math.min(screenDim.getWidth() + 1, screenDim.getHeight() + 1);
                double scale = (double)minScreenSize / (double)maxTextureSize;
                MobTalkerLog.trace(LOG_TAG, "MaxTextureSize: %s, MinScreenSize = %s, scale = %s", maxTextureSize, minScreenSize, scale);
                this.setScale(scale);
                break;
            }
            case FILL: {
                int minTextureSize = Math.min(this.getBounds().getWidth(), this.getBounds().getHeight());
                int maxScreenSize = Math.max(screenDim.getWidth() + 1, screenDim.getHeight() + 1);
                double scale = (double)maxScreenSize / (double)minTextureSize;
                MobTalkerLog.trace(LOG_TAG, "MinTextureSize: %s, MaxScreenSize = %s, scale = %s", minTextureSize, maxScreenSize, scale);
                this.setScale(scale);
                break;
            }
            case REPEAT: {
                break;
            }
            case REPEAT_X: {
                break;
            }
            case REPEAT_Y: {
                break;
            }
            case STRETCH: {
                break;
            }
        }
        super.doLayout(screenDim);
    }
}

