/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.util.mgt;

import com.google.common.base.Preconditions;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.mobtalker.mobtalker2.util.logging.MobTalkerLog;
import net.mobtalker.mobtalker2.util.mgt.Alignment;
import net.mobtalker.mobtalker2.util.mgt.Dimension;
import net.mobtalker.mobtalker2.util.mgt.IMouseListener;
import net.mobtalker.mobtalker2.util.mgt.MGDrawable;
import net.mobtalker.mobtalker2.util.mgt.MutableRectangle;
import net.mobtalker.mobtalker2.util.mgt.Point;
import net.mobtalker.mobtalker2.util.mgt.Rectangle;

@SideOnly(value=Side.CLIENT)
public abstract class MGComponent
extends MGDrawable {
    private static final String LOG_TAG = "MGT";
    private final int _id;
    private boolean _enableMouseEvents;
    protected final ArrayList<IMouseListener> _mouseListener;
    protected boolean _isMouseInside;
    private Alignment _alignFrom;
    private Alignment _alignTo;
    private Point _alignOffset;
    private final MutableRectangle _bounds;

    protected MGComponent(int id) {
        this._id = id;
        this._enableMouseEvents = true;
        this._mouseListener = new ArrayList(1);
        this._alignFrom = Alignment.TOPLEFT;
        this._alignTo = Alignment.TOPLEFT;
        this._alignOffset = new Point(0, 0);
        this._bounds = new MutableRectangle();
    }

    @Override
    public void doLayout(Dimension screenDim) {
        Rectangle parent = this._parent != null && this._parent instanceof MGComponent ? ((MGComponent)this._parent).getBounds() : new Rectangle(0, screenDim.getWidth(), 0, screenDim.getHeight());
        int x = this._alignTo.getX().getCoordinate(parent) + this._alignOffset.getX();
        switch (this._alignFrom.getX()) {
            case LEFT: {
                this._bounds.setLeft(x);
                break;
            }
            case CENTER: {
                this._bounds.setCenterX(x);
                break;
            }
            case RIGHT: {
                this._bounds.setRight(x);
            }
        }
        int y = this._alignTo.getY().getCoordinate(parent) + this._alignOffset.getY();
        switch (this._alignFrom.getY()) {
            case TOP: {
                this._bounds.setTop(y);
                break;
            }
            case CENTER: {
                this._bounds.setCenterY(y);
                break;
            }
            case BOTTOM: {
                this._bounds.setBottom(y);
            }
        }
        MobTalkerLog.trace(LOG_TAG, "AlignTo: %s, AlignFrom: %s, Offset: %s, Bounds: %s", new Object[]{this._alignTo, this._alignFrom, this._alignOffset, this.getBounds()});
    }

    @Override
    public void update() {
    }

    @Override
    public boolean onMouseMoved(int x, int y, boolean concealed) {
        if (!concealed && this._bounds.contains(x, y)) {
            if (!this._isMouseInside) {
                this._isMouseInside = true;
                this.fireMouseEntered();
            }
            this.fireMouseMoved(x, y);
            return this.isVisible();
        }
        if (this._isMouseInside) {
            this._isMouseInside = false;
            this.fireMouseLeft();
        }
        return false;
    }

    @Override
    public final boolean onMouseClicked(int x, int y, int button) {
        if (!this.isVisible()) {
            return false;
        }
        if (this._bounds.contains(x, y)) {
            this.fireMouseClicked(x, y, button);
            return true;
        }
        return false;
    }

    @Override
    public final boolean onMouseUp(int x, int y) {
        if (!this.isVisible()) {
            return false;
        }
        if (this._bounds.contains(x, y)) {
            this.fireMouseUp(x, y);
            return true;
        }
        return false;
    }

    public boolean isMouseEventsEnabled() {
        return this._enableMouseEvents;
    }

    public void setMouseEventsEnabled(boolean flag) {
        this._enableMouseEvents = flag;
    }

    public void addMouseListener(IMouseListener l) {
        if (!this._mouseListener.contains(l)) {
            this._mouseListener.add(l);
        }
    }

    public void removeMouseListener(IMouseListener l) {
        this._mouseListener.remove(l);
    }

    protected void fireMouseClicked(int x, int y, int button) {
        if (!this._enableMouseEvents) {
            return;
        }
        for (IMouseListener l : this._mouseListener) {
            l.mouseClicked(this, x, y, button);
        }
    }

    protected void fireMouseUp(int x, int y) {
        if (!this._enableMouseEvents) {
            return;
        }
        for (IMouseListener l : this._mouseListener) {
            l.mouseUp(this, x, y);
        }
    }

    protected void fireMouseMoved(int x, int y) {
        if (!this._enableMouseEvents) {
            return;
        }
        for (IMouseListener l : this._mouseListener) {
            l.mouseMoved(this, x, y);
        }
    }

    protected void fireMouseEntered() {
        if (!this._enableMouseEvents) {
            return;
        }
        for (IMouseListener l : this._mouseListener) {
            l.mouseEntered(this);
        }
    }

    protected void fireMouseLeft() {
        if (!this._enableMouseEvents) {
            return;
        }
        for (IMouseListener l : this._mouseListener) {
            l.mouseLeft(this);
        }
    }

    public int getId() {
        return this._id;
    }

    public Alignment getAlignFrom() {
        return this._alignFrom;
    }

    public Alignment getAlignTo() {
        return this._alignTo;
    }

    public Point getAlignOffset() {
        return this._alignOffset;
    }

    public Rectangle getBounds() {
        return this._bounds;
    }

    public void setAlign(Alignment from, MGComponent parent, Alignment to) {
        this.setAlignFrom(from);
        this.setParent(parent);
        this.setAlignTo(to);
        this.setAlignOffset(Point.ZERO);
    }

    public void setAlign(Alignment from, MGComponent parent, Alignment to, Point offset) {
        this.setAlignFrom(from);
        this.setParent(parent);
        this.setAlignTo(to);
        this.setAlignOffset(offset);
    }

    public void setAlign(Alignment from, MGComponent parent, Alignment to, int x, int y) {
        this.setAlignFrom(from);
        this.setParent(parent);
        this.setAlignTo(to);
        this.setAlignOffset(new Point(x, y));
    }

    public void setAlign(Alignment from, Alignment to) {
        this.setAlignFrom(from);
        this.setParent(null);
        this.setAlignTo(to);
        this.setAlignOffset(Point.ZERO);
    }

    public void setAlign(Alignment from, Alignment to, Point offset) {
        this.setAlignFrom(from);
        this.setParent(null);
        this.setAlignTo(to);
        this.setAlignOffset(offset);
    }

    public void setAlign(Alignment from, Alignment to, int x, int y) {
        this.setAlignFrom(from);
        this.setParent(null);
        this.setAlignTo(to);
        this.setAlignOffset(new Point(x, y));
    }

    public void setAlignFrom(Alignment alignFrom) {
        this._alignFrom = alignFrom;
        this.invalidate();
    }

    public void setAlignTo(Alignment alignTo) {
        this._alignTo = alignTo;
        this.invalidate();
    }

    public void setAlignOffset(Point alignOffset) {
        this._alignOffset = alignOffset;
        this.invalidate();
    }

    public void setAlignOffset(int x, int y) {
        this.setAlignOffset(new Point(x, y));
    }

    public void setSize(Dimension size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    public void setSize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public void setWidth(int width) {
        Preconditions.checkArgument((width >= 0 ? 1 : 0) != 0);
        this._bounds.setWidth(width);
        this.invalidate();
    }

    public void setHeight(int height) {
        Preconditions.checkArgument((height >= 0 ? 1 : 0) != 0);
        this._bounds.setHeight(height);
        this.invalidate();
    }

    public void setScale(double scale) {
        Preconditions.checkArgument((0.0 < scale ? 1 : 0) != 0);
        this.setWidth((int)((double)this._bounds.getWidth() * scale));
        this.setHeight((int)((double)this._bounds.getHeight() * scale));
    }
}

