/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.scriptpack;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mobtalker.mobtalker2.server.scriptpack.IScriptPack;
import net.mobtalker.mobtalker2.server.scriptpack.IScriptPackEntry;

abstract class AbstractScriptPack
implements IScriptPack {
    protected final Path _path;
    protected final String _name;
    protected final String _version;
    protected final String _descr;
    protected final List<String> _authors;
    protected final Map<String, IScriptPackEntry> _entries;
    protected boolean _isResourcePack;

    protected AbstractScriptPack(Path path, String name, String version, String descr, List<String> authors) {
        this._path = path;
        this._name = name;
        this._version = version;
        this._descr = descr;
        this._authors = authors;
        this._entries = Maps.newHashMap();
    }

    @Override
    public Path getPath() {
        return this._path;
    }

    @Override
    public String getTitle() {
        return this._name;
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public String getDescription() {
        return this._descr;
    }

    @Override
    public List<String> getAuthors() {
        return this._authors;
    }

    @Override
    public boolean isResourcePack() {
        return this._isResourcePack;
    }

    void addEntry(String name, IScriptPackEntry entry) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)entry);
        this._entries.put(name, entry);
    }

    @Override
    public Set<String> getSupportedEntities() {
        return Collections.unmodifiableSet(this._entries.keySet());
    }

    @Override
    public boolean hasEntryFor(String entity) {
        return this._entries.containsKey(entity);
    }

    @Override
    public IScriptPackEntry getEntryFor(String entity) {
        Preconditions.checkArgument((boolean)this.hasEntryFor(entity), (String)"no entry for entity '%s'", (Object[])new Object[]{entity});
        return this._entries.get(entity);
    }

    @Override
    public void close() {
    }
}

