/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.EnumChatFormatting;
import net.mobtalker.mobtalker2.server.script.InteractionScriptFactory;
import net.mobtalker.mobtalker2.server.scriptpack.IScriptPackEntry;
import net.mobtalker.mobtalker2.server.scriptpack.ScriptPackRepository;
import net.mobtalker.mobtalker2.util.ChatMessageHelper;
import net.mobtalker.mobtalkerscript.v2.compiler.MtsSyntaxError;

public class ServerConnectionHandler {
    private static final ServerConnectionHandler instance = new ServerConnectionHandler();

    public static void register() {
        FMLCommonHandler.instance().bus().register((Object)instance);
    }

    @SubscribeEvent
    public void onClientConnected(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        NetHandlerPlayServer handler = (NetHandlerPlayServer)event.handler;
        EntityPlayerMP player = handler.field_147369_b;
        this.printNoScriptsWarning((EntityPlayer)player);
        this.printScriptErrorsToPlayer((EntityPlayer)player);
    }

    private void printNoScriptsWarning(EntityPlayer player) {
        if (ScriptPackRepository.isLoaded() && !ScriptPackRepository.instance().hasScripts()) {
            ChatMessageHelper.sendMessageToPlayer(player, "[MobTalker2] This server has no interaction scripts.", EnumChatFormatting.RED, new Object[0]);
        }
    }

    private void printScriptErrorsToPlayer(EntityPlayer player) {
        Map<IScriptPackEntry, MtsSyntaxError> syntaxErrors;
        if (InteractionScriptFactory.isLoaded() && !(syntaxErrors = InteractionScriptFactory.instance().getSyntaxErrors()).isEmpty()) {
            ChatMessageHelper.sendMessageToPlayer(player, "[MobTalker2] Some interaction scripts contain syntax errors", EnumChatFormatting.RED, new Object[0]);
            for (Map.Entry<IScriptPackEntry, MtsSyntaxError> entry : syntaxErrors.entrySet()) {
                ChatMessageHelper.sendMessageToPlayer(player, " - " + entry.getValue().getMessage(), EnumChatFormatting.RED, new Object[0]);
            }
        }
    }
}

