/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.launch.dependencies;

import com.google.gson.JsonObject;
import cpw.mods.fml.common.versioning.ComparableVersion;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.mobtalker.mobtalker2.launch.dependencies.DependencyException;
import net.mobtalker.mobtalker2.util.JsonUtil;

public class DependencyInfo {
    private final String _name;
    private final ComparableVersion _remoteVersion;
    private final URL _downloadUrl;

    public static DependencyInfo fromUrl(URL infoUrl) {
        JsonObject json;
        try {
            json = JsonUtil.readFromUrl(infoUrl, 1000).getAsJsonObject();
        }
        catch (IOException ex) {
            throw new DependencyException("Error while trying to retrive DependencyInfo from", ex, infoUrl);
        }
        return DependencyInfo.fromJson(json);
    }

    public static DependencyInfo fromJson(JsonObject json) {
        URL downloadUrl;
        String nameStr = json.get("name").getAsString();
        String versionStr = json.get("version").getAsString();
        String urlStr = json.get("url").getAsString();
        ComparableVersion version = new ComparableVersion(versionStr);
        try {
            downloadUrl = new URL(urlStr);
        }
        catch (MalformedURLException ex) {
            throw new DependencyException("Recieved invalid download URL for %s", ex, nameStr);
        }
        return new DependencyInfo(nameStr, version, downloadUrl);
    }

    public DependencyInfo(String name, ComparableVersion remoteVersion, URL downloadUrl) {
        this._name = name;
        this._remoteVersion = remoteVersion;
        this._downloadUrl = downloadUrl;
    }

    public String getName() {
        return this._name;
    }

    public ComparableVersion getVersion() {
        return this._remoteVersion;
    }

    public URL getDownloadUrl() {
        return this._downloadUrl;
    }

    public String getFileName() {
        String pathStr = this._downloadUrl.getPath();
        String fileNameStr = pathStr.substring(pathStr.lastIndexOf(47) + 1);
        return fileNameStr;
    }
}

