/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.launch;

import com.google.gson.JsonObject;
import cpw.mods.fml.common.versioning.ComparableVersion;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.mobtalker.mobtalker2.util.JsonUtil;
import net.mobtalker.mobtalker2.util.logging.MobTalkerLog;

public class VersionChecker
implements Runnable {
    private static final String LOG_TAG = "VersionChecker";
    private static final String _versionUrl = "http://www.mobtalker.net/version/MobTalker2.json";
    private static boolean _newerVersionAvailable;
    private static ComparableVersion _newestVersion;

    public static boolean newerVersionAvailable() {
        return _newerVersionAvailable;
    }

    public static ComparableVersion getNewestVersion() {
        return _newestVersion;
    }

    @Override
    public void run() {
        if ("1.7.10-0.4.0-alpha".startsWith("@")) {
            MobTalkerLog.info(LOG_TAG, "Skipping version check because we're in a dev environment");
            return;
        }
        try {
            MobTalkerLog.info(LOG_TAG, "Beginning version check...");
            ComparableVersion currentVersion = new ComparableVersion("1.7.10-0.4.0-alpha");
            _newestVersion = this.retrieveNewestVersion();
            if (currentVersion.compareTo(_newestVersion) < 0) {
                MobTalkerLog.warn(LOG_TAG, "Found newer version of MobTalker2 (%s), consider updating!", _newestVersion.toString());
                _newerVersionAvailable = true;
            } else {
                MobTalkerLog.info(LOG_TAG, "Running newest version of MobTalker2");
                _newerVersionAvailable = false;
            }
        }
        catch (Exception ex) {
            MobTalkerLog.warn(LOG_TAG, "Unable to check version", ex);
            _newerVersionAvailable = false;
        }
    }

    private ComparableVersion retrieveNewestVersion() throws MalformedURLException, IOException {
        JsonObject json = JsonUtil.readFromUrl(new URL(_versionUrl), 1000).getAsJsonObject();
        String versionStr = json.get("version").getAsString();
        return new ComparableVersion(versionStr);
    }
}

