/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.common.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayerMP;
import net.mobtalker.mobtalker2.common.network.ClientToServerMessage;
import net.mobtalker.mobtalker2.common.network.MessageCancelInteraction;
import net.mobtalker.mobtalker2.common.network.MessageHideTexture;
import net.mobtalker.mobtalker2.common.network.MessageShowMenu;
import net.mobtalker.mobtalker2.common.network.MessageShowMenuResponse;
import net.mobtalker.mobtalker2.common.network.MessageShowScene;
import net.mobtalker.mobtalker2.common.network.MessageShowSprite;
import net.mobtalker.mobtalker2.common.network.MessageShowText;
import net.mobtalker.mobtalker2.common.network.MessageShowTextResponse;
import net.mobtalker.mobtalker2.common.network.ServerToClientMessage;
import net.mobtalker.mobtalker2.util.logging.MobTalkerLog;

public class NetworkManager {
    private static final String LOG_TAG = "NetworkManager";
    private static final SimpleNetworkWrapper _channel = NetworkRegistry.INSTANCE.newSimpleChannel("mobtalker2");

    public static void load() {
        NetworkManager.registerServerMessage(MessageShowText.class, 4);
        NetworkManager.registerServerMessage(MessageShowMenu.class, 5);
        NetworkManager.registerServerMessage(MessageShowSprite.class, 6);
        NetworkManager.registerServerMessage(MessageShowScene.class, 7);
        NetworkManager.registerServerMessage(MessageHideTexture.class, 8);
        NetworkManager.registerClientMessage(MessageCancelInteraction.class, 2);
        NetworkManager.registerClientMessage(MessageShowTextResponse.class, -4);
        NetworkManager.registerClientMessage(MessageShowMenuResponse.class, -5);
    }

    private static <REQ extends ServerToClientMessage> void registerServerMessage(Class<REQ> messageClass, int discriminator) {
        try {
            Class<?> handlerClass = Class.forName(messageClass.getName() + "$Handler");
            _channel.registerMessage(handlerClass, messageClass, discriminator, Side.CLIENT);
        }
        catch (Exception ex) {
            MobTalkerLog.fatal(LOG_TAG, "Failed to register message type '%s'", ex, messageClass.getSimpleName());
        }
    }

    private static <REQ extends ClientToServerMessage> void registerClientMessage(Class<REQ> messageClass, int discriminator) {
        try {
            Class<?> handlerClass = Class.forName(messageClass.getName() + "$Handler");
            _channel.registerMessage(handlerClass, messageClass, discriminator, Side.SERVER);
        }
        catch (Exception ex) {
            MobTalkerLog.fatal(LOG_TAG, "Failed to register message type '%s'", ex, messageClass.getSimpleName());
        }
    }

    public static void sendToAll(IMessage message) {
        _channel.sendToAll(message);
    }

    public static void sendTo(IMessage message, EntityPlayerMP player) {
        _channel.sendTo(message, player);
    }

    public static void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        _channel.sendToAllAround(message, point);
    }

    public static void sendToDimension(IMessage message, int dimensionId) {
        _channel.sendToDimension(message, dimensionId);
    }

    public static void sendToServer(IMessage message) {
        _channel.sendToServer(message);
    }
}

